% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdpee.R
\name{kdpee}
\alias{kdpee}
\title{Fast Entropy Estimation of Multi-Dimensional Data}
\usage{
kdpee(X, ci = 0.95, lower = apply(X, 2, min), upper = apply(X, 2, max))
}
\arguments{
\item{X}{[\code{matrix}]\cr
Data, one observation per row.}

\item{ci}{[\code{numeric(1)}]\cr
Confidence threshold used to decide if a cell should be divided further.
Defaults to 95\%.}

\item{lower}{[\code{numeric(n)}]\cr
Lower bound of the support of \code{X}.}

\item{upper}{[\code{numeric(n)}]\cr
Upper bound of the support of \code{X}.}
}
\value{
Differential entropy estimate.
}
\description{
Non-parametric estimator for the differential entropy of a multidimensional distribution, given a limited set of data points, by a recursive rectilinear partitioning.
}
\examples{
Xu <- matrix(runif(1000 * 100), ncol=100)
kdpee(Xu)

Xn <- matrix(rnorm(1000 * 100), ncol=100)
kdpee(Xn)

}
\references{
D. Stowell and M. D. Plumbley
Fast multidimensional entropy estimation by k-d partitioning.
IEEE Signal Processing Letters 16 (6), 537--540, June 2009.
http://dx.doi.org/10.1109/LSP.2009.2017346
}
