% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-core.R
\name{layer_masking}
\alias{layer_masking}
\title{Masks a sequence by using a mask value to skip timesteps.}
\usage{
layer_masking(object, mask_value = 0, input_shape = NULL,
  batch_input_shape = NULL, batch_size = NULL, dtype = NULL,
  name = NULL, trainable = NULL, weights = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{mask_value}{float, mask value}

\item{input_shape}{Dimensionality of the input (integer) not including the
samples axis. This argument is required when using this layer as the first
layer in a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
For each timestep in the input tensor (dimension #1 in the tensor), if all
values in the input tensor at that timestep are equal to \code{mask_value}, then
the timestep will be masked (skipped) in all downstream layers (as long as
they support masking). If any downstream layer does not support masking yet
receives such an input mask, an exception will be raised.
}
\seealso{
Other core layers: \code{\link{layer_activation}},
  \code{\link{layer_activity_regularization}},
  \code{\link{layer_dense}}, \code{\link{layer_dropout}},
  \code{\link{layer_flatten}}, \code{\link{layer_input}},
  \code{\link{layer_lambda}}, \code{\link{layer_permute}},
  \code{\link{layer_repeat_vector}},
  \code{\link{layer_reshape}}
}
