% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{save_model_hdf5}
\alias{save_model_hdf5}
\alias{load_model_hdf5}
\title{Save/Load models using HDF5 files}
\usage{
save_model_hdf5(object, filepath, overwrite = TRUE,
  include_optimizer = TRUE)

load_model_hdf5(filepath, custom_objects = NULL, compile = TRUE)
}
\arguments{
\item{object}{Model object to save}

\item{filepath}{File path}

\item{overwrite}{Overwrite existing file if necessary}

\item{include_optimizer}{If \code{TRUE}, save optimizer's state.}

\item{custom_objects}{Mapping class names (or function names) of custom
(non-Keras) objects to class/functions (for example, custom metrics
or custom loss functions).}

\item{compile}{Whether to compile the model after loading.}
}
\description{
Save/Load models using HDF5 files
}
\details{
The following components of the model are saved:
\itemize{
\item The model architecture, allowing to re-instantiate the model.
\item The model weights.
\item The state of the optimizer, allowing to resume training exactly where you
left off.
This allows you to save the entirety of the state of a model
in a single file.
}

Saved models can be reinstantiated via \code{load_model_hdf5()}. The model returned by
\code{load_model_hdf5()} is a compiled model ready to be used (unless the saved model
was never compiled in the first place or \code{compile = FALSE} is specified).

As an alternative to providing the \code{custom_objects} argument, you can
execute the definition and persistence of your model using the
\code{\link[=with_custom_object_scope]{with_custom_object_scope()}} function.
}
\note{
The \code{\link[=serialize_model]{serialize_model()}} function enables saving Keras models to
R objects that can be persisted across R sessions.
}
\seealso{
Other model persistence: \code{\link{get_weights}},
  \code{\link{model_to_json}}, \code{\link{model_to_yaml}},
  \code{\link{save_model_weights_hdf5}},
  \code{\link{serialize_model}}
}
