% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_repeat_elements}
\alias{k_repeat_elements}
\title{Repeats the elements of a tensor along an axis.}
\usage{
k_repeat_elements(x, rep, axis)
}
\arguments{
\item{x}{Tensor or variable.}

\item{rep}{Integer, number of times to repeat.}

\item{axis}{Axis along which to repeat (axis indexes are 1-based)}
}
\value{
A tensor.
}
\description{
If \code{x} has shape \verb{(s1, s2, s3)} and \code{axis} is \code{2}, the output
will have shape \verb{(s1, s2 * rep, s3)}.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://tensorflow.rstudio.com/reference/keras/index.html#backend}.
}

