% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-activations.R
\name{layer_activation_parametric_relu}
\alias{layer_activation_parametric_relu}
\title{Parametric Rectified Linear Unit.}
\usage{
layer_activation_parametric_relu(
  object,
  alpha_initializer = "zeros",
  alpha_regularizer = NULL,
  alpha_constraint = NULL,
  shared_axes = NULL,
  input_shape = NULL,
  batch_input_shape = NULL,
  batch_size = NULL,
  dtype = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{alpha_initializer}{Initializer function for the weights.}

\item{alpha_regularizer}{Regularizer for the weights.}

\item{alpha_constraint}{Constraint for the weights.}

\item{shared_axes}{The axes along which to share learnable parameters for the
activation function. For example, if the incoming feature maps are from a
2D convolution with output shape (batch, height, width, channels), and you
wish to share parameters across space so that each filter only has one set
of parameters, set shared_axes=c(1, 2).}

\item{input_shape}{Input shape (list of integers, does not include the
samples axis) which is required when using this layer as the first layer in
a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
It follows: \verb{f(x) = alpha * x`` for }x < 0\verb{, }f(x) = x\code{for}x >= 0`, where
alpha is a learned array with the same shape as x.
}
\seealso{
\href{https://arxiv.org/abs/1502.01852}{Delving Deep into Rectifiers: Surpassing Human-Level Performance on ImageNet Classification}.

Other activation layers: 
\code{\link{layer_activation_elu}()},
\code{\link{layer_activation_leaky_relu}()},
\code{\link{layer_activation_relu}()},
\code{\link{layer_activation_selu}()},
\code{\link{layer_activation_softmax}()},
\code{\link{layer_activation_thresholded_relu}()},
\code{\link{layer_activation}()}
}
\concept{activation layers}
