% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-preprocessing.R
\name{layer_resizing}
\alias{layer_resizing}
\title{Image resizing layer}
\usage{
layer_resizing(
  object,
  height,
  width,
  interpolation = "bilinear",
  crop_to_aspect_ratio = FALSE,
  ...
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{height}{Integer, the height of the output shape.}

\item{width}{Integer, the width of the output shape.}

\item{interpolation}{String, the interpolation method. Defaults to \code{"bilinear"}.
Supports \code{"bilinear"}, \code{"nearest"}, \code{"bicubic"}, \code{"area"}, \code{"lanczos3"},
\code{"lanczos5"}, \code{"gaussian"}, and \code{"mitchellcubic"}.}

\item{crop_to_aspect_ratio}{If TRUE, resize the images without aspect
ratio distortion. When the original aspect ratio differs from the target
aspect ratio, the output image will be cropped so as to return the largest
possible window in the image (of size \verb{(height, width)}) that matches
the target aspect ratio. By default (\code{crop_to_aspect_ratio = FALSE}),
aspect ratio may not be preserved.}

\item{...}{standard layer arguments.}
}
\description{
Image resizing layer
}
\details{
Resize the batched image input to target height and width. The input should
be a 4D (batched) or 3D (unbatched) tensor in \code{"channels_last"} format.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/Resizing}
\item \url{https://keras.io/api/layers/preprocessing_layers/image_preprocessing/resizing}
}

Other image preprocessing layers: 
\code{\link{layer_center_crop}()},
\code{\link{layer_rescaling}()}

Other preprocessing layers: 
\code{\link{layer_category_encoding}()},
\code{\link{layer_center_crop}()},
\code{\link{layer_discretization}()},
\code{\link{layer_hashing}()},
\code{\link{layer_integer_lookup}()},
\code{\link{layer_normalization}()},
\code{\link{layer_random_brightness}()},
\code{\link{layer_random_contrast}()},
\code{\link{layer_random_crop}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_height}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_translation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()},
\code{\link{layer_rescaling}()},
\code{\link{layer_string_lookup}()},
\code{\link{layer_text_vectorization}()}
}
\concept{image preprocessing layers}
\concept{preprocessing layers}
