% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-merge.R
\name{layer_subtract}
\alias{layer_subtract}
\title{Layer that subtracts two inputs.}
\usage{
layer_subtract(inputs, ...)
}
\arguments{
\item{inputs}{A input tensor, or list of two input tensors. Can be missing.}

\item{...}{Unnamed args are treated as additional \code{inputs}. Named arguments are passed on as standard layer arguments.}
}
\value{
A tensor, the difference of the inputs. If \code{inputs} is missing, a
keras layer instance is returned.
}
\description{
It takes as input a list of tensors of size 2, both of the same shape, and
returns a single tensor, (\code{inputs[[1]] - inputs[[2]]}), also of the same
shape.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/subtract}
\item \url{https://keras.io/api/layers/merging_layers/subtract}
}

Other merge layers: 
\code{\link{layer_average}()},
\code{\link{layer_concatenate}()},
\code{\link{layer_dot}()},
\code{\link{layer_maximum}()},
\code{\link{layer_minimum}()},
\code{\link{layer_multiply}()}
}
\concept{merge layers}
