% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-pooling.R
\name{layer_global_max_pooling_1d}
\alias{layer_global_max_pooling_1d}
\title{Global max pooling operation for temporal data.}
\usage{
layer_global_max_pooling_1d(object, data_format = "channels_last",
  batch_size = NULL, name = NULL, trainable = NULL, weights = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{data_format}{One of \code{channels_last} (default) or \code{channels_first}.
The ordering of the dimensions in the inputs.}

\item{batch_size}{Fixed batch size for layer}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Global max pooling operation for temporal data.
}
\section{Input shape}{

3D tensor with shape: \code{(batch_size, steps, features)}.
}

\section{Output shape}{

2D tensor with shape: \code{(batch_size, channels)}
}

\seealso{
Other pooling layers: \code{\link{layer_average_pooling_1d}},
  \code{\link{layer_average_pooling_2d}},
  \code{\link{layer_average_pooling_3d}},
  \code{\link{layer_global_average_pooling_1d}},
  \code{\link{layer_global_average_pooling_2d}},
  \code{\link{layer_global_average_pooling_3d}},
  \code{\link{layer_global_max_pooling_2d}},
  \code{\link{layer_global_max_pooling_3d}},
  \code{\link{layer_max_pooling_1d}},
  \code{\link{layer_max_pooling_2d}},
  \code{\link{layer_max_pooling_3d}}
}
\concept{pooling layers}
