% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-core.R
\name{layer_dense}
\alias{layer_dense}
\title{Add a densely-connected NN layer to an output}
\usage{
layer_dense(
  object,
  units,
  activation = NULL,
  use_bias = TRUE,
  kernel_initializer = "glorot_uniform",
  bias_initializer = "zeros",
  kernel_regularizer = NULL,
  bias_regularizer = NULL,
  activity_regularizer = NULL,
  kernel_constraint = NULL,
  bias_constraint = NULL,
  input_shape = NULL,
  batch_input_shape = NULL,
  batch_size = NULL,
  dtype = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{units}{Positive integer, dimensionality of the output space.}

\item{activation}{Name of activation function to use. If you don't specify
anything, no activation is applied (ie. "linear" activation: a(x) = x).}

\item{use_bias}{Whether the layer uses a bias vector.}

\item{kernel_initializer}{Initializer for the \code{kernel} weights matrix.}

\item{bias_initializer}{Initializer for the bias vector.}

\item{kernel_regularizer}{Regularizer function applied to the \code{kernel}
weights matrix.}

\item{bias_regularizer}{Regularizer function applied to the bias vector.}

\item{activity_regularizer}{Regularizer function applied to the output of the
layer (its "activation")..}

\item{kernel_constraint}{Constraint function applied to the \code{kernel} weights
matrix.}

\item{bias_constraint}{Constraint function applied to the bias vector.}

\item{input_shape}{Dimensionality of the input (integer) not including the
samples axis. This argument is required when using this layer as the first
layer in a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Implements the operation: \code{output = activation(dot(input, kernel) + bias)}
where \code{activation} is the element-wise activation function passed as the
\code{activation} argument, \code{kernel} is a weights matrix created by the layer, and
\code{bias} is a bias vector created by the layer (only applicable if \code{use_bias}
is \code{TRUE}). Note: if the input to the layer has a rank greater than 2, then
it is flattened prior to the initial dot product with \code{kernel}.
}
\section{Input and Output Shapes}{


Input shape: nD tensor with shape: \verb{(batch_size, ..., input_dim)}. The most
common situation would be a 2D input with shape \verb{(batch_size, input_dim)}.

Output shape: nD tensor with shape: \verb{(batch_size, ..., units)}. For
instance, for a 2D input with shape \verb{(batch_size, input_dim)}, the output
would have shape \verb{(batch_size, unit)}.
}

\seealso{
Other core layers: 
\code{\link{layer_activation}()},
\code{\link{layer_activity_regularization}()},
\code{\link{layer_attention}()},
\code{\link{layer_dense_features}()},
\code{\link{layer_dropout}()},
\code{\link{layer_flatten}()},
\code{\link{layer_input}()},
\code{\link{layer_lambda}()},
\code{\link{layer_masking}()},
\code{\link{layer_permute}()},
\code{\link{layer_repeat_vector}()},
\code{\link{layer_reshape}()}
}
\concept{core layers}
