% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_auc}
\alias{metric_auc}
\title{Approximates the AUC (Area under the curve) of the ROC or PR curves}
\usage{
metric_auc(
  ...,
  num_thresholds = 200L,
  curve = "ROC",
  summation_method = "interpolation",
  thresholds = NULL,
  multi_label = FALSE,
  num_labels = NULL,
  label_weights = NULL,
  from_logits = FALSE,
  name = NULL,
  dtype = NULL
)
}
\arguments{
\item{...}{Passed on to the underlying metric. Used for forwards and backwards compatibility.}

\item{num_thresholds}{(Optional) Defaults to 200. The number of thresholds toa
use when discretizing the roc curve. Values must be > 1.}

\item{curve}{(Optional) Specifies the name of the curve to be computed, 'ROC'
(default) or 'PR' for the Precision-Recall-curve.}

\item{summation_method}{(Optional) Specifies the \href{https://en.wikipedia.org/wiki/Riemann_sum}{Riemann summation method} used. 'interpolation' (default)
applies mid-point summation scheme for \code{ROC}. For PR-AUC, interpolates
(true/false) positives but not the ratio that is precision (see Davis &
Goadrich 2006 for details); 'minoring' applies left summation for
increasing intervals and right summation for decreasing intervals;
'majoring' does the opposite.}

\item{thresholds}{(Optional) A list of floating point values to use as the
thresholds for discretizing the curve. If set, the \code{num_thresholds}
parameter is ignored. Values should be in \verb{[0, 1]}. Endpoint thresholds equal
to {-epsilon, 1+epsilon} for a small positive epsilon value will be
automatically included with these to correctly handle predictions equal to
exactly 0 or 1.}

\item{multi_label}{boolean indicating whether multilabel data should be
treated as such, wherein AUC is computed separately for each label and then
averaged across labels, or (when FALSE) if the data should be flattened
into a single label before AUC computation. In the latter case, when
multilabel data is passed to AUC, each label-prediction pair is treated as
an individual data point. Should be set to FALSE for multi-class data.}

\item{num_labels}{(Optional) The number of labels, used when \code{multi_label} is
TRUE. If \code{num_labels} is not specified, then state variables get created on
the first call to \code{update_state}.}

\item{label_weights}{(Optional) list, array, or tensor of non-negative
weights used to compute AUCs for multilabel data. When \code{multi_label} is
TRUE, the weights are applied to the individual label AUCs when they are
averaged to produce the multi-label AUC. When it's FALSE, they are used to
weight the individual label predictions in computing the confusion matrix
on the flattened data. Note that this is unlike class_weights in that
class_weights weights the example depending on the value of its label,
whereas label_weights depends only on the index of that label before
flattening; therefore \code{label_weights} should not be used for multi-class
data.}

\item{from_logits}{boolean indicating whether the predictions (\code{y_pred} in
\code{update_state}) are probabilities or sigmoid logits. As a rule of thumb,
when using a keras loss, the \code{from_logits} constructor argument of the loss
should match the AUC \code{from_logits} constructor argument.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}
}
\value{
A (subclassed) \code{Metric} instance that can be passed directly to
\code{compile(metrics = )}, or used as a standalone object. See \code{?Metric} for
example usage.
}
\description{
Approximates the AUC (Area under the curve) of the ROC or PR curves
}
\details{
The AUC (Area under the curve) of the ROC (Receiver operating
characteristic; default) or PR (Precision Recall) curves are quality measures
of binary classifiers. Unlike the accuracy, and like cross-entropy losses,
ROC-AUC and PR-AUC evaluate all the operational points of a model.

This class approximates AUCs using a Riemann sum. During the metric
accumulation phrase, predictions are accumulated within predefined buckets by
value. The AUC is then computed by interpolating per-bucket averages. These
buckets define the evaluated operational points.

This metric creates four local variables, \code{true_positives}, \code{true_negatives},
\code{false_positives} and \code{false_negatives} that are used to compute the AUC. To
discretize the AUC curve, a linearly spaced set of thresholds is used to
compute pairs of recall and precision values. The area under the ROC-curve is
therefore computed using the height of the recall values by the false
positive rate, while the area under the PR-curve is the computed using the
height of the precision values by the recall.

This value is ultimately returned as \code{auc}, an idempotent operation that
computes the area under a discretized curve of precision versus recall values
(computed using the aforementioned variables). The \code{num_thresholds} variable
controls the degree of discretization with larger numbers of thresholds more
closely approximating the true AUC. The quality of the approximation may vary
dramatically depending on \code{num_thresholds}. The \code{thresholds} parameter can be
used to manually specify thresholds which split the predictions more evenly.

For a best approximation of the real AUC, \code{predictions} should be distributed
approximately uniformly in the range \verb{[0, 1]} (if \code{from_logits=FALSE}). The
quality of the AUC approximation may be poor if this is not the case. Setting
\code{summation_method} to 'minoring' or 'majoring' can help quantify the error in
the approximation by providing lower or upper bound estimate of the AUC.

If \code{sample_weight} is \code{NULL}, weights default to 1. Use \code{sample_weight} of 0
to mask values.
}
\seealso{
Other metrics: 
\code{\link{custom_metric}()},
\code{\link{metric_accuracy}()},
\code{\link{metric_binary_accuracy}()},
\code{\link{metric_binary_crossentropy}()},
\code{\link{metric_categorical_accuracy}()},
\code{\link{metric_categorical_crossentropy}()},
\code{\link{metric_categorical_hinge}()},
\code{\link{metric_cosine_similarity}()},
\code{\link{metric_false_negatives}()},
\code{\link{metric_false_positives}()},
\code{\link{metric_hinge}()},
\code{\link{metric_kullback_leibler_divergence}()},
\code{\link{metric_logcosh_error}()},
\code{\link{metric_mean_absolute_error}()},
\code{\link{metric_mean_absolute_percentage_error}()},
\code{\link{metric_mean_iou}()},
\code{\link{metric_mean_relative_error}()},
\code{\link{metric_mean_squared_error}()},
\code{\link{metric_mean_squared_logarithmic_error}()},
\code{\link{metric_mean_tensor}()},
\code{\link{metric_mean_wrapper}()},
\code{\link{metric_mean}()},
\code{\link{metric_poisson}()},
\code{\link{metric_precision_at_recall}()},
\code{\link{metric_precision}()},
\code{\link{metric_recall_at_precision}()},
\code{\link{metric_recall}()},
\code{\link{metric_root_mean_squared_error}()},
\code{\link{metric_sensitivity_at_specificity}()},
\code{\link{metric_sparse_categorical_accuracy}()},
\code{\link{metric_sparse_categorical_crossentropy}()},
\code{\link{metric_sparse_top_k_categorical_accuracy}()},
\code{\link{metric_specificity_at_sensitivity}()},
\code{\link{metric_squared_hinge}()},
\code{\link{metric_sum}()},
\code{\link{metric_top_k_categorical_accuracy}()},
\code{\link{metric_true_negatives}()},
\code{\link{metric_true_positives}()}
}
\concept{metrics}
