% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-attention.R
\name{layer_attention}
\alias{layer_attention}
\title{Creates attention layer}
\usage{
layer_attention(
  inputs,
  use_scale = FALSE,
  causal = FALSE,
  batch_size = NULL,
  dtype = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{inputs}{a list of inputs first should be the query tensor, the second the value tensor}

\item{use_scale}{If True, will create a scalar variable to scale the attention scores.}

\item{causal}{Boolean. Set to True for decoder self-attention. Adds a mask such that position i cannot attend to positions j > i.
This prevents the flow of information from the future towards the past.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Dot-product attention layer, a.k.a. Luong-style attention.
}
\seealso{
Other core layers: 
\code{\link{layer_activation}()},
\code{\link{layer_activity_regularization}()},
\code{\link{layer_dense_features}()},
\code{\link{layer_dense}()},
\code{\link{layer_dropout}()},
\code{\link{layer_flatten}()},
\code{\link{layer_input}()},
\code{\link{layer_lambda}()},
\code{\link{layer_masking}()},
\code{\link{layer_permute}()},
\code{\link{layer_repeat_vector}()},
\code{\link{layer_reshape}()}
}
\concept{attention layers}
\concept{core layers}
