% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-recurrent-cells.R
\name{layer_rnn}
\alias{layer_rnn}
\title{Base class for recurrent layers}
\usage{
layer_rnn(
  object,
  cell,
  return_sequences = FALSE,
  return_state = FALSE,
  go_backwards = FALSE,
  stateful = FALSE,
  unroll = FALSE,
  time_major = FALSE,
  ...,
  zero_output_for_mask = FALSE
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{cell}{A RNN cell instance or a list of RNN cell instances.
A RNN cell is a class that has:
\itemize{
\item A \code{call(input_at_t, states_at_t)} method, returning
\verb{(output_at_t, states_at_t_plus_1)}. The call method of the
cell can also take the optional argument \code{constants}, see
section "Note on passing external constants" below.
\item A \code{state_size} attribute. This can be a single integer
(single state) in which case it is the size of the recurrent
state. This can also be a list of integers (one size per state).
The \code{state_size} can also be TensorShape or list of
TensorShape, to represent high dimension state.
\item A \code{output_size} attribute. This can be a single integer or a
TensorShape, which represent the shape of the output. For backward
compatible reason, if this attribute is not available for the
cell, the value will be inferred by the first element of the
\code{state_size}.
\item A \code{get_initial_state(inputs=NULL, batch_size=NULL, dtype=NULL)}
method that creates a tensor meant to be fed to \code{call()} as the
initial state, if the user didn't specify any initial state via other
means. The returned initial state should have a shape of
\verb{[batch_size, cell$state_size]}. The cell might choose to create a
tensor full of zeros, or full of other values based on the cell's
implementation.
\code{inputs} is the input tensor to the RNN layer, which should
contain the batch size as first dimension (\code{inputs$shape[1]}),
and also dtype (\code{inputs$dtype}). Note that
the \code{shape[1]} might be \code{NULL} during the graph construction. Either
the \code{inputs} or the pair of \code{batch_size} and \code{dtype} are provided.
\code{batch_size} is a scalar tensor that represents the batch size
of the inputs. \code{dtype} is \code{tf.DType} that represents the dtype of
the inputs.
For backward compatibility, if this method is not implemented
by the cell, the RNN layer will create a zero filled tensor with the
size of \verb{[batch_size, cell$state_size]}.
In the case that \code{cell} is a list of RNN cell instances, the cells
will be stacked on top of each other in the RNN, resulting in an
efficient stacked RNN.
}}

\item{return_sequences}{Boolean (default \code{FALSE}). Whether to return the last
output in the output sequence, or the full sequence.}

\item{return_state}{Boolean (default \code{FALSE}). Whether to return the last state
in addition to the output.}

\item{go_backwards}{Boolean (default \code{FALSE}).
If \code{TRUE}, process the input sequence backwards and return the
reversed sequence.}

\item{stateful}{Boolean (default \code{FALSE}). If \code{TRUE}, the last state
for each sample at index \code{i} in a batch will be used as initial
state for the sample of index \code{i} in the following batch.}

\item{unroll}{Boolean (default \code{FALSE}).
If TRUE, the network will be unrolled, else a symbolic loop will be used.
Unrolling can speed-up a RNN, although it tends to be more
memory-intensive. Unrolling is only suitable for short sequences.}

\item{time_major}{The shape format of the \code{inputs} and \code{outputs} tensors.
If \code{TRUE}, the inputs and outputs will be in shape
\verb{(timesteps, batch, ...)}, whereas in the FALSE case, it will be
\verb{(batch, timesteps, ...)}. Using \code{time_major = TRUE} is a bit more
efficient because it avoids transposes at the beginning and end of the
RNN calculation. However, most TensorFlow data is batch-major, so by
default this function accepts input and emits output in batch-major
form.}

\item{...}{standard layer arguments.}

\item{zero_output_for_mask}{Boolean (default \code{FALSE}).
Whether the output should use zeros for the masked timesteps. Note that
this field is only used when \code{return_sequences} is TRUE and mask is
provided. It can useful if you want to reuse the raw output sequence of
the RNN without interference from the masked timesteps, eg, merging
bidirectional RNNs.}
}
\description{
Base class for recurrent layers
}
\details{
See \href{https://www.tensorflow.org/guide/keras/rnn}{the Keras RNN API guide}
for details about the usage of RNN API.
}
\section{Call arguments}{

\itemize{
\item \code{inputs}: Input tensor.
\item \code{mask}: Binary tensor of shape \verb{[batch_size, timesteps]} indicating whether
a given timestep should be masked. An individual \code{TRUE} entry indicates
that the corresponding timestep should be utilized, while a \code{FALSE}
entry indicates that the corresponding timestep should be ignored.
\item \code{training}: R or Python Boolean indicating whether the layer should behave in
training mode or in inference mode. This argument is passed to the cell
when calling it. This is for use with cells that use dropout.
\item \code{initial_state}: List of initial state tensors to be passed to the first
call of the cell.
\item \code{constants}: List of constant tensors to be passed to the cell at each
timestep.
}
}

\section{Input shapes}{


N-D tensor with shape \verb{(batch_size, timesteps, ...)},
or \verb{(timesteps, batch_size, ...)} when \code{time_major = TRUE}.
}

\section{Output shape}{

\itemize{
\item if \code{return_state}: a list of tensors. The first tensor is
the output. The remaining tensors are the last states,
each with shape \verb{(batch_size, state_size)}, where \code{state_size}
could be a high dimension tensor shape.
\item if \code{return_sequences}: N-D tensor with shape \verb{[batch_size, timesteps, output_size]}, where \code{output_size} could be a high dimension tensor shape, or
\verb{[timesteps, batch_size, output_size]} when \code{time_major} is \code{TRUE}
\item else, N-D tensor with shape \verb{[batch_size, output_size]}, where
\code{output_size} could be a high dimension tensor shape.
}
}

\section{Masking}{


This layer supports masking for input data with a variable number of
timesteps. To introduce masks to your data, use
\code{\link[=layer_embedding]{layer_embedding()}} with the \code{mask_zero} parameter set to \code{TRUE}.
}

\section{Statefulness in RNNs}{


You can set RNN layers to be 'stateful', which means that the states computed
for the samples in one batch will be reused as initial states for the samples
in the next batch. This assumes a one-to-one mapping between samples in
different successive batches.

For intuition behind statefulness, there is a helpful blog post here:
\url{https://philipperemy.github.io/keras-stateful-lstm/}

To enable statefulness:
\itemize{
\item Specify \code{stateful = TRUE} in the layer constructor.
\item Specify a fixed batch size for your model. For sequential models,
pass \code{batch_input_shape = list(...)} to the first layer in your model.
For functional models with 1 or more Input layers, pass
\code{batch_shape = list(...)} to all the first layers in your model.
This is the expected shape of your inputs \emph{including the batch size}.
It should be a list of integers, e.g. \code{list(32, 10, 100)}.
For dimensions which can vary (are not known ahead of time),
use \code{NULL} in place of an integer, e.g. \code{list(32, NULL, NULL)}.
\item Specify \code{shuffle = FALSE} when calling \code{fit()}.
}

To reset the states of your model, call \code{layer$reset_states()} on either
a specific layer, or on your entire model.
}

\section{Initial State of RNNs}{


You can specify the initial state of RNN layers symbolically by calling them
with the keyword argument \code{initial_state.} The value of initial_state should
be a tensor or list of tensors representing the initial state of the RNN
layer.

You can specify the initial state of RNN layers numerically by calling
\code{reset_states} with the named argument \code{states.} The value of \code{states} should
be an array or list of arrays representing the initial state of the RNN
layer.
}

\section{Passing external constants to RNNs}{


You can pass "external" constants to the cell using the \code{constants} named
argument of \verb{RNN$__call__} (as well as \code{RNN$call}) method. This requires that the
\code{cell$call} method accepts the same keyword argument \code{constants}. Such constants
can be used to condition the cell transformation on additional static inputs
(not changing over time), a.k.a. an attention mechanism.
}

\seealso{
\itemize{
\item \url{https://www.tensorflow.org/guide/keras/rnn}
}

\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/RNN}
\item \url{https://keras.io/api/layers/recurrent_layers/rnn}
\item \code{reticulate::py_help(keras$layers$RNN)}
}

Other recurrent layers: 
\code{\link{layer_cudnn_gru}()},
\code{\link{layer_cudnn_lstm}()},
\code{\link{layer_gru}()},
\code{\link{layer_lstm}()},
\code{\link{layer_simple_rnn}()}
}
\concept{recurrent layers}
