% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-convolutional.R
\name{layer_upsampling_1d}
\alias{layer_upsampling_1d}
\title{Upsampling layer for 1D inputs.}
\usage{
layer_upsampling_1d(
  object,
  size = 2L,
  batch_size = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{size}{integer. Upsampling factor.}

\item{batch_size}{Fixed batch size for layer}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Repeats each temporal step \code{size} times along the time axis.
}
\section{Input shape}{
 3D tensor with shape: \verb{(batch, steps, features)}.
}

\section{Output shape}{
 3D tensor with shape: \verb{(batch, upsampled_steps, features)}.
}

\seealso{
Other convolutional layers: 
\code{\link{layer_conv_1d_transpose}()},
\code{\link{layer_conv_1d}()},
\code{\link{layer_conv_2d_transpose}()},
\code{\link{layer_conv_2d}()},
\code{\link{layer_conv_3d_transpose}()},
\code{\link{layer_conv_3d}()},
\code{\link{layer_conv_lstm_2d}()},
\code{\link{layer_cropping_1d}()},
\code{\link{layer_cropping_2d}()},
\code{\link{layer_cropping_3d}()},
\code{\link{layer_depthwise_conv_2d}()},
\code{\link{layer_separable_conv_1d}()},
\code{\link{layer_separable_conv_2d}()},
\code{\link{layer_upsampling_2d}()},
\code{\link{layer_upsampling_3d}()},
\code{\link{layer_zero_padding_1d}()},
\code{\link{layer_zero_padding_2d}()},
\code{\link{layer_zero_padding_3d}()}
}
\concept{convolutional layers}
