% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_mean}
\alias{k_mean}
\title{Mean of a tensor, alongside the specified axis.}
\usage{
k_mean(x, axis = NULL, keepdims = FALSE)
}
\arguments{
\item{x}{A tensor or variable.}

\item{axis}{A list of axes to compute the mean over (axis indexes are
1-based).}

\item{keepdims}{A boolean, whether to keep the dimensions or not. If
\code{keepdims} is \code{FALSE}, the rank of the tensor is reduced by 1 for each
entry in \code{axis}. If \code{keep_dims} is \code{TRUE}, the reduced dimensions are
retained with length 1.}
}
\value{
A tensor with the mean of elements of \code{x}.
}
\description{
Mean of a tensor, alongside the specified axis.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

