% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_keras}
\alias{install_keras}
\title{Install Keras}
\usage{
install_keras(
  envname = "r-keras",
  ...,
  extra_packages = c("scipy", "pandas", "Pillow", "pydot", "ipython",
    "tensorflow_datasets"),
  python_version = ">=3.9,<=3.11",
  backend = "tensorflow",
  gpu = NA,
  restart_session = TRUE
)
}
\arguments{
\item{envname}{Name of or path to a Python virtual environment}

\item{...}{reserved for future compatability.}

\item{extra_packages}{Additional Python packages to install alongside Keras}

\item{python_version}{Passed on to \code{reticulate::virtualenv_starter()}}

\item{backend}{Which backend(s) to install. Accepted values include \code{"tensorflow"}, \code{"jax"} and \code{"pytorch"}}

\item{gpu}{whether to install a GPU capable version of the backend.}

\item{restart_session}{Whether to restart the R session after installing (note this will only occur within RStudio).}
}
\value{
No return value, called for side effects.
}
\description{
This function will install Keras along with a selected backend, including all Python dependencies.
}
\seealso{
\code{\link[tensorflow:install_tensorflow]{tensorflow::install_tensorflow()}}
}
