% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{custom_metric}
\alias{custom_metric}
\title{Custom metric function}
\usage{
custom_metric(name, metric_fn)
}
\arguments{
\item{name}{name used to show training progress output}

\item{metric_fn}{An R function with signature \verb{function(y_true, y_pred)}
that accepts tensors.}
}
\value{
A callable function with a \verb{__name__} attribute.
}
\description{
Custom metric function
}
\details{
You can provide an arbitrary R function as a custom metric. Note that
the \code{y_true} and \code{y_pred} parameters are tensors, so computations on
them should use \verb{op_*} tensor functions.

Use the \code{custom_metric()} function to define a custom metric.
Note that a name (\code{'mean_pred'}) is provided for the custom metric
function: this name is used within training progress output.

If you want to save and load a model with custom metrics, you should
also call \code{\link[=register_keras_serializable]{register_keras_serializable()}}, or
specify the metric in the call the \code{\link[=load_model]{load_model()}}. For example:
\code{load_model("my_model.keras", c('mean_pred' = metric_mean_pred))}.

Alternatively, you can wrap all of your code in a call to
\code{\link[=with_custom_object_scope]{with_custom_object_scope()}} which will allow you to refer to the
metric by name just like you do with built in keras metrics.

Alternative ways of supplying custom metrics:
\itemize{
\item \verb{custom_metric():} Arbitrary R function.
\item \code{\link[=metric_mean_wrapper]{metric_mean_wrapper()}}: Wrap an arbitrary R function in a \code{Metric} instance.
\item Create a custom \code{\link[=Metric]{Metric()}} subclass.
}
}
\seealso{
Other metrics: \cr
\code{\link{Metric}()} \cr
\code{\link{metric_auc}()} \cr
\code{\link{metric_binary_accuracy}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_categorical_accuracy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_f1_score}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_fbeta_score}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_iou}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_mean_wrapper}()} \cr
\code{\link{metric_one_hot_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr
\code{\link{metric_sensitivity_at_specificity}()} \cr
\code{\link{metric_sparse_categorical_accuracy}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_sparse_top_k_categorical_accuracy}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_squared_hinge}()} \cr
\code{\link{metric_sum}()} \cr
\code{\link{metric_top_k_categorical_accuracy}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr
}
\concept{metrics}
