% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{get_registered_object}
\alias{get_registered_object}
\title{Returns the class associated with \code{name} if it is registered with Keras.}
\usage{
get_registered_object(name, custom_objects = NULL, module_objects = NULL)
}
\arguments{
\item{name}{The name to look up.}

\item{custom_objects}{A named list of custom objects to look the name up in.
Generally, custom_objects is provided by the user.}

\item{module_objects}{A named list of custom objects to look the name up in.
Generally, \code{module_objects} is provided by midlevel library
implementers.}
}
\value{
An instantiable class associated with \code{name}, or \code{NULL} if no such class
exists.
}
\description{
This function is part of the Keras serialization and deserialization
framework. It maps strings to the objects associated with them for
serialization/deserialization.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{from_config <- function(cls, config, custom_objects = NULL) \{
  if ('my_custom_object_name' \\\%in\\\% names(config)) \{
    config$hidden_cls <- get_registered_object(
      config$my_custom_object_name,
      custom_objects = custom_objects)
  \}
\}
}\if{html}{\out{</div>}}
}

\seealso{
Other serialization utilities: \cr
\code{\link{deserialize_keras_object}()} \cr
\code{\link{get_custom_objects}()} \cr
\code{\link{get_registered_name}()} \cr
\code{\link{register_keras_serializable}()} \cr
\code{\link{serialize_keras_object}()} \cr
\code{\link{with_custom_object_scope}()} \cr
}
\concept{serialization utilities}
