% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{save_model_weights}
\alias{save_model_weights}
\title{Saves all layer weights to a \code{.weights.h5} file.}
\usage{
save_model_weights(model, filepath, overwrite = FALSE)
}
\arguments{
\item{model}{A keras Model object}

\item{filepath}{string.
Path where to save the model. Must end in \code{.weights.h5}.}

\item{overwrite}{Whether we should overwrite any existing model
at the target location, or instead ask the user
via an interactive prompt.}
}
\value{
This is called primarily for side effects. \code{model} is returned,
invisibly, to enable usage with the pipe.
}
\description{
Saves all layer weights to a \code{.weights.h5} file.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/models/model_saving_apis/weights_saving_and_loading#saveweights-method}
}

Other saving and loading functions: \cr
\code{\link{export_savedmodel.keras.src.models.model.Model}()} \cr
\code{\link{layer_tfsm}()} \cr
\code{\link{load_model}()} \cr
\code{\link{load_model_weights}()} \cr
\code{\link{register_keras_serializable}()} \cr
\code{\link{save_model}()} \cr
\code{\link{save_model_config}()} \cr
\code{\link{with_custom_object_scope}()} \cr
}
\concept{saving and loading functions}
