% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-utils.R
\name{unpack_x_y_sample_weight}
\alias{unpack_x_y_sample_weight}
\title{Unpacks user-provided data list.}
\usage{
unpack_x_y_sample_weight(data)
}
\arguments{
\item{data}{A list of the form \code{(x)}, \verb{(x, y)}, or \verb{(x, y, sample_weight)}.}
}
\value{
The unpacked list, with \code{NULL}s for \code{y} and \code{sample_weight} if they are
not provided.
}
\description{
This is a convenience utility to be used when overriding
\verb{$train_step}, \verb{$test_step}, or \verb{$predict_step}.
This utility makes it easy to support data of the form \verb{(x,)},
\verb{(x, y)}, or \verb{(x, y, sample_weight)}.
}
\section{Example:}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{features_batch <- op_ones(c(10, 5))
labels_batch <- op_zeros(c(10, 5))
data <- list(features_batch, labels_batch)
# `y` and `sample_weight` will default to `NULL` if not provided.
c(x, y, sample_weight) \%<-\% unpack_x_y_sample_weight(data)
}\if{html}{\out{</div>}}

You can also do the equivalent by providing default values to \verb{\%<-\%}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{c(x, y = NULL, sample_weight = NULL) \%<-\% data
}\if{html}{\out{</div>}}
}

\seealso{
Other data utils: \cr
\code{\link{pack_x_y_sample_weight}()} \cr
\code{\link{zip_lists}()} \cr

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pack_x_y_sample_weight}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{zip_lists}()} \cr
}
\concept{data utils}
\concept{utils}
\keyword{internal}
