% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image-utils.R
\name{image_array_save}
\alias{image_array_save}
\title{Saves an image stored as an array to a path or file object.}
\usage{
image_array_save(
  x,
  path,
  data_format = NULL,
  file_format = NULL,
  scale = TRUE,
  ...
)
}
\arguments{
\item{x}{An array.}

\item{path}{Path or file object.}

\item{data_format}{Image data format, either \code{"channels_first"} or
\code{"channels_last"}.}

\item{file_format}{Optional file format override. If omitted, the format to
use is determined from the filename extension. If a file object was
used instead of a filename, this parameter should always be used.}

\item{scale}{Whether to rescale image values to be within \verb{[0, 255]}.}

\item{...}{Additional keyword arguments passed to \code{PIL.Image.save()}.}
}
\value{
Called primarily for side effects. The input \code{x} is returned,
invisibly, to enable usage with the pipe.
}
\description{
Saves an image stored as an array to a path or file object.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/data_loading/image#saveimg-function}
}

Other image utils: \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{op_image_affine_transform}()} \cr
\code{\link{op_image_crop}()} \cr
\code{\link{op_image_extract_patches}()} \cr
\code{\link{op_image_map_coordinates}()} \cr
\code{\link{op_image_pad}()} \cr
\code{\link{op_image_resize}()} \cr
\code{\link{op_image_rgb_to_grayscale}()} \cr

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{zip_lists}()} \cr
}
\concept{image utils}
\concept{utils}
