% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history.R
\name{plot.keras_training_history}
\alias{plot.keras_training_history}
\title{Plot training history}
\usage{
\method{plot}{keras_training_history}(
  x,
  y,
  metrics = NULL,
  method = c("auto", "ggplot2", "base"),
  smooth = getOption("keras.plot.history.smooth", TRUE),
  theme_bw = getOption("keras.plot.history.theme_bw", FALSE),
  ...
)
}
\arguments{
\item{x}{Training history object returned from
\code{\link[=fit.keras.src.models.model.Model]{fit.keras.src.models.model.Model()}}.}

\item{y}{Unused.}

\item{metrics}{One or more metrics to plot (e.g. \code{c('loss', 'accuracy')}).
Defaults to plotting all captured metrics.}

\item{method}{Method to use for plotting. The default "auto" will use
\pkg{ggplot2} if available, and otherwise will use base graphics.}

\item{smooth}{Whether a loess smooth should be added to the plot, only
available for the \code{ggplot2} method. If the number of epochs is smaller
than ten, it is forced to false.}

\item{theme_bw}{Use \code{ggplot2::theme_bw()} to plot the history in
black and white.}

\item{...}{Additional parameters to pass to the \code{\link[=plot]{plot()}} method.}
}
\value{
if \code{method == "ggplot2"}, the ggplot object is returned. If
\code{method == "base"}, then this function will draw to the graphics device and
return \code{NULL}, invisibly.
}
\description{
Plots metrics recorded during training.
}
