% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-training.R
\name{fit.keras.src.models.model.Model}
\alias{fit.keras.src.models.model.Model}
\title{Train a model for a fixed number of epochs (dataset iterations).}
\usage{
\method{fit}{keras.src.models.model.Model}(
  object,
  x = NULL,
  y = NULL,
  ...,
  batch_size = NULL,
  epochs = 1L,
  callbacks = NULL,
  validation_split = 0,
  validation_data = NULL,
  shuffle = TRUE,
  class_weight = NULL,
  sample_weight = NULL,
  initial_epoch = 1L,
  steps_per_epoch = NULL,
  validation_steps = NULL,
  validation_batch_size = NULL,
  validation_freq = 1L,
  verbose = getOption("keras.verbose", default = "auto"),
  view_metrics = getOption("keras.view_metrics", default = "auto")
)
}
\arguments{
\item{object}{Keras model object}

\item{x}{Input data. It can be:
\itemize{
\item An array (or array-like), or a list of arrays
(in case the model has multiple inputs).
\item A backend-native tensor, or a list of tensors
(in case the model has multiple inputs).
\item A named list mapping input names to the corresponding array/tensors,
if the model has named inputs.
\item A \code{tf.data.Dataset}. Should return a tuple
of either \verb{(inputs, targets)} or
\verb{(inputs, targets, sample_weights)}.
\item A generator returning \verb{(inputs, targets)} or
\verb{(inputs, targets, sample_weights)}.
}}

\item{y}{Target data. Like the input data \code{x},
it can be either array(s) or backend-native tensor(s).
If \code{x} is a TF Dataset or generator,
\code{y} should
not be specified (since targets will be obtained from \code{x}).}

\item{...}{Additional arguments passed on to the model \code{fit()} method.}

\item{batch_size}{Integer or \code{NULL}.
Number of samples per gradient update.
If unspecified, \code{batch_size} will default to \code{32}.
Do not specify the \code{batch_size} if your data is in the
form of TF Datasets or generators,
(since they generate batches).}

\item{epochs}{Integer. Number of epochs to train the model.
An epoch is an iteration over the entire \code{x} and \code{y}
data provided
(unless the \code{steps_per_epoch} flag is set to
something other than \code{NULL}).
Note that in conjunction with \code{initial_epoch},
\code{epochs} is to be understood as "final epoch".
The model is not trained for a number of iterations
given by \code{epochs}, but merely until the epoch
of index \code{epochs} is reached.}

\item{callbacks}{List of \code{Callback()} instances.
List of callbacks to apply during training.
See \verb{callback_*}.}

\item{validation_split}{Fraction of the training data to be used as validation data.
The model will set apart this fraction of the training data,
will not train on it, and will evaluate the loss and any model
metrics on this data at the end of each epoch. The validation
data is selected from the last samples in the \code{x} and \code{y} data
provided, before shuffling.
This argument is only supported when \code{x} and \code{y} are made of
arrays or tensors.
If both \code{validation_data} and \code{validation_split} are provided,
\code{validation_data} will override \code{validation_split}.}

\item{validation_data}{Data on which to evaluate
the loss and any model metrics at the end of each epoch.
The model will not be trained on this data. Thus, note the fact
that the validation loss of data provided using
\code{validation_split} or \code{validation_data} is not affected by
regularization layers like noise and dropout.
\code{validation_data} will override \code{validation_split}.
It can be:
\itemize{
\item A tuple \verb{(x_val, y_val)} of arrays or tensors.
\item A tuple \verb{(x_val, y_val, val_sample_weights)} of
arrays.
\item A generator returning
\verb{(inputs, targets)} or \verb{(inputs, targets, sample_weights)}.
}}

\item{shuffle}{Boolean, whether to shuffle the training data
before each epoch. This argument is
ignored when \code{x} is a generator or a TF Dataset.}

\item{class_weight}{Optional named list mapping class indices (integers, 0-based)
to a weight (float) value, used for weighting the loss function
(during training only).
This can be useful to tell the model to
"pay more attention" to samples from
an under-represented class. When \code{class_weight} is specified
and targets have a rank of 2 or greater, either \code{y} must be
one-hot encoded, or an explicit final dimension of \code{1} must
be included for sparse class labels.}

\item{sample_weight}{Optional array or tensor of weights for
the training samples, used for weighting the loss function
(during training only). You can either pass a flat (1D)
array or tensor with the same length as the input samples
(1:1 mapping between weights and samples), or in the case of
temporal data, you can pass a 2D array or tensor with
shape \verb{(samples, sequence_length)} to apply a different weight
to every timestep of every sample.
This argument is not supported when \code{x} is a
\code{tf.data.Dataset}, or Python generator function.
Instead, provide \code{sample_weights} as the third element of \code{x}.
Note that sample weighting does not apply to metrics specified
via the \code{metrics} argument in \code{compile()}. To apply sample
weighting to your metrics, you can specify them via the
\code{weighted_metrics} in \code{compile()} instead.}

\item{initial_epoch}{Integer.
Epoch at which to start training
(useful for resuming a previous training run).}

\item{steps_per_epoch}{Integer or \code{NULL}.
Total number of steps (batches of samples) before declaring one
epoch finished and starting the next epoch. When training with
input tensors or arrays, the default \code{NULL} means that the
value used is the number of samples in your dataset divided by
the batch size, or \code{1} if that cannot be determined.
If \code{x} is a \code{tf.data.Dataset}
or Python generator function, the
epoch will run until the input dataset is exhausted. When
passing an infinitely repeating dataset, you must specify the
\code{steps_per_epoch} argument, otherwise the training will run
indefinitely.}

\item{validation_steps}{Only relevant if \code{validation_data} is provided.
Total number of steps (batches of samples) to draw before
stopping when performing validation at the end of every epoch.
If \code{validation_steps} is \code{NULL}, validation will run until the
\code{validation_data} dataset is exhausted. In the case of an
infinitely repeating dataset, it will run indefinitely. If
\code{validation_steps} is specified and only part of the dataset
is consumed, the evaluation will start from the beginning of the
dataset at each epoch. This ensures that the same validation
samples are used every time.}

\item{validation_batch_size}{Integer or \code{NULL}.
Number of samples per validation batch.
If unspecified, will default to \code{batch_size}.
Do not specify the \code{validation_batch_size} if your data is in
the form of TF Datasets or generator
instances (since they generate batches).}

\item{validation_freq}{Only relevant if validation data is provided.
Specifies how many training epochs to run
before a new validation run is performed,
e.g. \code{validation_freq=2} runs validation every 2 epochs.}

\item{verbose}{\code{"auto"}, \code{0}, \code{1}, or \code{2}. Verbosity mode.
\code{0} = silent, \code{1} = progress bar, \code{2} = one line per epoch.
\code{"auto"} becomes 1 for most cases,
\code{2} if in a knitr render or running on a distributed training server.
Note that the progress bar is not
particularly useful when logged to a file,
so \code{verbose=2} is recommended when not running interactively
(e.g., in a production environment). Defaults to \code{"auto"}.}

\item{view_metrics}{View realtime plot of training metrics (by epoch). The
default (\code{"auto"}) will display the plot when running within RStudio,
\code{metrics} were specified during model \code{\link[=compile]{compile()}}, \code{epochs > 1} and
\code{verbose > 0}. Set the global \code{options(keras.view_metrics = )} option to
establish a different default.}
}
\value{
A \code{keras_training_history} object, which is a named list:
\verb{list(params = <params>, metrics = <metrics>")}, with S3 methods
\code{print()}, \code{plot()}, and \code{as.data.frame()}. The metrics
field is
a record of training loss values and metrics values
at successive epochs, as well as validation loss values
and validation metrics values (if applicable).
}
\description{
Train a model for a fixed number of epochs (dataset iterations).
}
\details{
Unpacking behavior for iterator-like inputs:

A common pattern is to pass an iterator like object such as a
\code{tf.data.Dataset} or a generator to \code{fit()},
which will in fact yield not only features (\code{x})
but optionally targets (\code{y}) and sample weights (\code{sample_weight}).
Keras requires that the output of such iterator-likes be
unambiguous. The iterator should return a \code{tuple()}
of length 1, 2, or 3, where the optional second and third elements
will be used for \code{y} and \code{sample_weight} respectively.
Any other type provided will be wrapped in
a length-one \code{tuple()}, effectively treating everything as \code{x}. When
yielding named lists, they should still adhere to the top-level tuple
structure,
e.g. \code{tuple(list(x0 = x0, x = x1), y)}. Keras will not attempt to separate
features, targets, and weights from the keys of a single dict.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/models/model_training_apis#fit-method}
}
}
