% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-methods.R
\name{get_config}
\alias{get_config}
\alias{from_config}
\title{Layer/Model configuration}
\usage{
get_config(object)

from_config(config, custom_objects = NULL)
}
\arguments{
\item{object}{Layer or model object}

\item{config}{Object with layer or model configuration}

\item{custom_objects}{list of custom objects needed to instantiate the layer,
e.g., custom layers defined by \code{new_layer_class()} or similar.}
}
\value{
\code{get_config()} returns an object with the configuration,
\code{from_config()} returns a re-instantiation of the object.
}
\description{
A layer config is an object returned from \code{get_config()} that contains the
configuration of a layer or model. The same layer or model can be
reinstantiated later (without its trained weights) from this configuration
using \code{from_config()}. The config does not include connectivity information,
nor the class name (those are handled externally).
}
\note{
Objects returned from \code{get_config()} are not serializable via RDS. If
you want to save and restore a model across sessions, you can use
\code{\link[=save_model_config]{save_model_config()}} (for model configuration only, not weights)
or \code{\link[=save_model]{save_model()}} to save the model configuration and weights
to the filesystem.
}
\seealso{
Other model functions: \cr
\code{\link{get_layer}()} \cr
\code{\link{get_state_tree}()} \cr
\code{\link{keras_model}()} \cr
\code{\link{keras_model_sequential}()} \cr
\code{\link{pop_layer}()} \cr
\code{\link{set_state_tree}()} \cr
\code{\link{summary.keras.src.models.model.Model}()} \cr

Other layer methods: \cr
\code{\link{count_params}()} \cr
\code{\link{get_weights}()} \cr
\code{\link{quantize_weights}()} \cr
\code{\link{reset_state}()} \cr
}
\concept{layer methods}
\concept{model functions}
