% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{loss_circle}
\alias{loss_circle}
\title{Computes Circle Loss between integer labels and L2-normalized embeddings.}
\usage{
loss_circle(
  y_true,
  y_pred,
  ref_labels = NULL,
  ref_embeddings = NULL,
  remove_diagonal = TRUE,
  gamma = 80L,
  margin = 0.4,
  ...,
  reduction = "sum_over_batch_size",
  name = "circle",
  dtype = NULL
)
}
\arguments{
\item{y_true}{Tensor with ground truth labels in integer format.}

\item{y_pred}{Tensor with predicted L2 normalized embeddings.}

\item{ref_labels}{Optional integer tensor with labels for reference
embeddings. If \code{NULL}, defaults to \code{y_true}.}

\item{ref_embeddings}{Optional tensor with L2 normalized reference embeddings.
If \code{NULL}, defaults to \code{y_pred}.}

\item{remove_diagonal}{Boolean, whether to remove self-similarities from the
positive mask. Defaults to \code{TRUE}.}

\item{gamma}{Scaling factor that determines the largest scale of each
similarity score. Defaults to \code{80}.}

\item{margin}{The relaxation factor, below this distance, negatives are
up weighted and positives are down weighted. Similarly, above this
distance negatives are down weighted and positive are up weighted.
Defaults to \code{0.4}.}

\item{...}{For forward/backward compatability.}

\item{reduction}{Type of reduction to apply to the loss. In almost all cases
this should be \code{"sum_over_batch_size"}. Supported options are
\code{"sum"}, \code{"sum_over_batch_size"}, \code{"mean"},
\code{"mean_with_sample_weight"} or \code{NULL}. \code{"sum"} sums the loss,
\code{"sum_over_batch_size"} and \code{"mean"} sum the loss and divide by the
sample size, and \code{"mean_with_sample_weight"} sums the loss and
divides by the sum of the sample weights. \code{"none"} and \code{NULL}
perform no aggregation. Defaults to \code{"sum_over_batch_size"}.}

\item{name}{Optional name for the loss instance.}

\item{dtype}{The dtype of the loss's computations. Defaults to \code{NULL}, which
means using \code{config_floatx()}. \code{config_floatx()} is a
\code{"float32"} unless set to different value
(via \code{config_set_floatx()}). If a \code{keras.DTypePolicy} is
provided, then the \code{compute_dtype} will be utilized.}
}
\value{
Circle loss value.
}
\description{
It is designed to minimize within-class distances and maximize between-class
distances in L2 normalized embedding space.

This is a metric learning loss designed to minimize within-class distance
and maximize between-class distance in a flexible manner by dynamically
adjusting the penalty strength based on optimization status of each
similarity score.

To use Circle Loss effectively, the model should output embeddings without
an activation function (such as a \code{Dense} layer with \code{activation=NULL})
followed by \code{UnitNormalization} layer to ensure unit-norm embeddings.
}
\section{Examples}{
Usage with the \code{compile()} API:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model <- keras_model_sequential(input_shape = c(224, 224, 3)) |>
  layer_conv_2d(16, c(3, 3), activation = 'relu') |>
  layer_flatten() |>
  layer_dense(64, activation = NULL) |>   # No activation
  layer_unit_normalization()  # L2 normalization

model |>
  compile(optimizer = "adam", loss = loss_circle())
}\if{html}{\out{</div>}}
}

\section{Reference}{
\itemize{
\item \href{https://arxiv.org/abs/2002.10857}{Yifan Sun et al., 2020}
}
}

\seealso{
Other losses: \cr
\code{\link{Loss}()} \cr
\code{\link{loss_binary_crossentropy}()} \cr
\code{\link{loss_binary_focal_crossentropy}()} \cr
\code{\link{loss_categorical_crossentropy}()} \cr
\code{\link{loss_categorical_focal_crossentropy}()} \cr
\code{\link{loss_categorical_hinge}()} \cr
\code{\link{loss_cosine_similarity}()} \cr
\code{\link{loss_ctc}()} \cr
\code{\link{loss_dice}()} \cr
\code{\link{loss_hinge}()} \cr
\code{\link{loss_huber}()} \cr
\code{\link{loss_kl_divergence}()} \cr
\code{\link{loss_log_cosh}()} \cr
\code{\link{loss_mean_absolute_error}()} \cr
\code{\link{loss_mean_absolute_percentage_error}()} \cr
\code{\link{loss_mean_squared_error}()} \cr
\code{\link{loss_mean_squared_logarithmic_error}()} \cr
\code{\link{loss_poisson}()} \cr
\code{\link{loss_sparse_categorical_crossentropy}()} \cr
\code{\link{loss_squared_hinge}()} \cr
\code{\link{loss_tversky}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_squared_hinge}()} \cr
}
\concept{losses}
