% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{load_model_weights}
\alias{load_model_weights}
\title{Load weights from a file saved via \code{save_model_weights()}.}
\usage{
load_model_weights(model, filepath, skip_mismatch = FALSE, ...)
}
\arguments{
\item{model}{A keras model.}

\item{filepath}{String, path to the weights file to load.
It can either be a \code{.weights.h5} file
or a legacy \code{.h5} weights file.}

\item{skip_mismatch}{Boolean, whether to skip loading of layers where
there is a mismatch in the number of weights, or a mismatch in
the shape of the weights.}

\item{...}{For forward/backward compatability.}
}
\value{
This is called primarily for side effects. \code{model} is returned,
invisibly, to enable usage with the pipe.
}
\description{
Weights are loaded based on the network's
topology. This means the architecture should be the same as when the
weights were saved. Note that layers that don't have weights are not
taken into account in the topological ordering, so adding or removing
layers is fine as long as they don't have weights.

\strong{Partial weight loading}

If you have modified your model, for instance by adding a new layer
(with weights) or by changing the shape of the weights of a layer,
you can choose to ignore errors and continue loading
by setting \code{skip_mismatch=TRUE}. In this case any layer with
mismatching weights will be skipped. A warning will be displayed
for each skipped layer.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/models/model_saving_apis/weights_saving_and_loading#loadweights-method}
}

Other saving and loading functions: \cr
\code{\link{export_savedmodel.keras.src.models.model.Model}()} \cr
\code{\link{layer_tfsm}()} \cr
\code{\link{load_model}()} \cr
\code{\link{register_keras_serializable}()} \cr
\code{\link{save_model}()} \cr
\code{\link{save_model_config}()} \cr
\code{\link{save_model_weights}()} \cr
\code{\link{with_custom_object_scope}()} \cr
}
\concept{saving and loading functions}
