% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.wrappers.R
\name{LayerWrapper}
\alias{LayerWrapper}
\alias{TimeDistributed}
\alias{Bidirectional}
\title{Layer wrappers}
\usage{
TimeDistributed(layer)

Bidirectional(layer, merge_mode = "concat")
}
\arguments{
\item{layer}{a layer instance (must be a recurrent layer for the
bi-directional case)}

\item{merge_mode}{Mode by which outputs of the forward and backward RNNs
will be combined. One of {'sum', 'mul', 'concat', 'ave',
None}. If None, the outputs will not be combined,
they will be returned as a list.}
}
\description{
Apply a layer to every temporal slice of an input or to bi-directional
RNN.
}
\examples{
if(keras_available()) {
  X_train <- matrix(sample(0:19, 100 * 100, TRUE), ncol = 100)
  Y_train <- rnorm(100)
  
  mod <- Sequential()
  mod$add(Embedding(input_dim = 20, output_dim = 10,
                    input_length = 100))
  mod$add(Dropout(0.5))
  
  mod$add(Bidirectional(LSTM(16)))
  mod$add(Dense(1))
  mod$add(Activation("sigmoid"))
  
  keras_compile(mod, loss = "mse", optimizer = RMSprop())
  keras_fit(mod, X_train, Y_train, epochs = 3, verbose = 0)
}
}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\seealso{
Other layers: \code{\link{Activation}},
  \code{\link{ActivityRegularization}},
  \code{\link{AdvancedActivation}},
  \code{\link{BatchNormalization}}, \code{\link{Conv}},
  \code{\link{Dense}}, \code{\link{Dropout}},
  \code{\link{Embedding}}, \code{\link{Flatten}},
  \code{\link{GaussianNoise}},
  \code{\link{LocallyConnected}}, \code{\link{Masking}},
  \code{\link{MaxPooling}}, \code{\link{Permute}},
  \code{\link{RNN}}, \code{\link{RepeatVector}},
  \code{\link{Reshape}}, \code{\link{Sequential}}
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
