% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.kms_fit}
\alias{predict.kms_fit}
\title{predict.kms_fit}
\usage{
\method{predict}{kms_fit}(object, newdata, batch_size = 32, verbose = 0,
  ...)
}
\arguments{
\item{object}{output from kms()}

\item{newdata}{new data. Performs merge so that x_test has the same columns as the object created by kms_fit using the user-provided input formula. y_test is also generated from that formula.}

\item{batch_size}{To be passed to keras::predict_classes. Default == 32.}

\item{verbose}{0 ot 1, to be passed to keras::predict_classes. Default == 0.}

\item{...}{additional parameters to build the sparse matrix x_test.}
}
\value{
list containing predictions, y_test, confusion matrix.
}
\description{
predict function for kms_fit object. Wrapper for keras::predict_classes(). Creates a sparse model matrix with the same columns as the training data, some of which may be 0.
}
\examples{
if(is_keras_available()){

 mtcars$make <- unlist(lapply(strsplit(rownames(mtcars), " "), function(tokens) tokens[1]))
 company <- kms(make ~ ., mtcars[3:32, ], Nepochs = 2)
 forecast <- predict(company, mtcars[1:2, ])
 forecast$confusion
 
}else{
   cat("Please run install_keras() before using kms(). ?install_keras for options like gpu.")
}
}
\author{
Pete Mohanty
}
