% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{keyATM_read}
\alias{keyATM_read}
\title{Read texts}
\usage{
keyATM_read(texts, encoding = "UTF-8", check = TRUE, progress_bar = FALSE)
}
\arguments{
\item{texts}{input. keyATM takes quanteda dfm (dgCMatrix), data.frame, \pkg{tibble} tbl_df, or a vector of file paths.}

\item{encoding}{character. Only used when \code{texts} is a vector of file paths. Default is \code{UTF-8}.}

\item{check}{logical. If \code{TRUE}, check whether there is anything wrong with the structure of texts. Default is \code{TRUE}.}

\item{progress_bar}{logical. If \code{TRUE}, it shows a progress bar (currently it only supports a quanteda object). Default is \code{FALSE}.}
}
\value{
a list whose elements are splitted texts. The length of the list equals to the number of documents.
}
\description{
Read texts and create a \code{keyATM_docs} object, which is a list of texts.
}
\examples{
\dontrun{
 # Use quanteda dfm
 keyATM_docs <- keyATM_read(texts = quanteda_dfm) 
  
 # Use data.frame or tibble (texts should be stored in a column named `text`)
 keyATM_docs <- keyATM_read(texts = data_frame_object) 
 keyATM_docs <- keyATM_read(texts = tibble_object) 

 # Use a vector that stores full paths to the text files 
 files <- list.files(doc_folder, pattern = "*.txt", full.names = TRUE) 
 keyATM_docs <- keyATM_read(texts = files) 

}
}
