# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Checking if a word is in a document
#'
#' @param doc a vector
#' @param word a word to check
#' @return bool
#'
#' @keywords internal
word_in_doc <- function(doc, word) {
    .Call(`_keyATM_word_in_doc`, doc, word)
}

#' Calculate the probability for Polya-Gamma Covariate Model
#'
#' Same as utils::calc_PGtheta, but this is for calling from R
#'
#' @param theta_tilda Parameters
#' @param theta Parameters
#' @param num_doc Number of documents
#' @param num_topics Number of topics
#'
#' @keywords internal
calc_PGtheta_R <- function(theta_tilda, theta, num_doc, num_topics) {
    .Call(`_keyATM_calc_PGtheta_R`, theta_tilda, theta, num_doc, num_topics)
}

#' Initialize assignments
#'
#' @param docs_ Documents
#' @param info_ Various information
#' @param initialized_ Store initialized objects (W, S and Z)
#'
#' @keywords internal
make_wsz_cpp <- function(docs_, info_, initialized_) {
    .Call(`_keyATM_make_wsz_cpp`, docs_, info_, initialized_)
}

#' Run the Variational Bayes for the keyATM models
#'
#' @param model A model
#'
#' @keywords internal
keyATMvb_call <- function(model) {
    .Call(`_keyATM_keyATMvb_call`, model)
}

#' Read files from the quanteda dfm (this is the same as dgCMatrix)
#'
#' @param dfm a dfm input (sparse Matrix)
#' @param W_read an object to return
#' @param vocab a vector of vocabulary
#' @param split split proportion
#'
#' @keywords internal
read_dfm_cpp <- function(dfm, W_read, vocab, split) {
    .Call(`_keyATM_read_dfm_cpp`, dfm, W_read, vocab, split)
}

#' Run the Collapsed Gibbs sampler for the keyATM Base
#'
#' @param model A initialized model
#' @param resume resume or not
#'
#' @keywords internal
keyATM_fit_base <- function(model, resume = FALSE) {
    .Call(`_keyATM_keyATM_fit_base`, model, resume)
}

#' Run the Collapsed Gibbs sampler for the keyATM covariates (Dir-Multi)
#'
#' @param model A initialized model
#' @param resume resume or not
#'
#' @keywords internal
keyATM_fit_cov <- function(model, resume = FALSE) {
    .Call(`_keyATM_keyATM_fit_cov`, model, resume)
}

#' Run the Collapsed Gibbs sampler for the keyATM covariates (Polya-Gamma)
#'
#' @param model A initialized model
#' @param resume resume or not
#'
#' @keywords internal
keyATM_fit_covPG <- function(model, resume = FALSE) {
    .Call(`_keyATM_keyATM_fit_covPG`, model, resume)
}

#' Run the Collapsed Gibbs sampler for the keyATM Dynamic
#'
#' @param model A initialized model
#' @param resume resume or not
#'
#' @keywords internal
keyATM_fit_HMM <- function(model, resume = FALSE) {
    .Call(`_keyATM_keyATM_fit_HMM`, model, resume)
}

#' Run the Collapsed Gibbs sampler for weighted LDA
#'
#' @param model A initialized model
#' @param resume resume or not
#'
#' @keywords internal
keyATM_fit_LDA <- function(model, resume = FALSE) {
    .Call(`_keyATM_keyATM_fit_LDA`, model, resume)
}

#' Run the Collapsed Gibbs sampler for weighted LDA with covariates
#'
#' @param model A initialized model
#' @param resume resume or not
#'
#' @keywords internal
keyATM_fit_LDAcov <- function(model, resume = FALSE) {
    .Call(`_keyATM_keyATM_fit_LDAcov`, model, resume)
}

#' Run the Collapsed Gibbs sampler for the weighted LDA with HMM model
#'
#' @param model A initialized model
#' @param resume resume or not
#'
#' @keywords internal
keyATM_fit_LDAHMM <- function(model, resume = FALSE) {
    .Call(`_keyATM_keyATM_fit_LDAHMM`, model, resume)
}

