% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoped.R
\name{restore-keys-scoped}
\alias{restore-keys-scoped}
\alias{restore_keys_all}
\alias{restore_keys_if}
\alias{restore_keys_at}
\title{Restore selection of keys}
\usage{
restore_keys_all(.tbl, .funs = list(), ..., .remove = FALSE,
  .unkey = FALSE)

restore_keys_if(.tbl, .predicate, .funs = list(), ..., .remove = FALSE,
  .unkey = FALSE)

restore_keys_at(.tbl, .vars, .funs = list(), ..., .remove = FALSE,
  .unkey = FALSE)
}
\arguments{
\item{.tbl}{Reference data frame.}

\item{.funs}{Parameter for \link[dplyr:scoped]{scoped} functions.}

\item{...}{Parameter for \link[dplyr:scoped]{scoped} functions.}

\item{.remove}{Whether to remove keys after restoring.}

\item{.unkey}{Whether to \code{\link[=unkey]{unkey()}} \code{.tbl} in case there are no keys left.}

\item{.predicate}{Parameter for \link[dplyr:scoped]{scoped} functions.}

\item{.vars}{Parameter for \link[dplyr:scoped]{scoped} functions.}
}
\description{
These functions restore selection of keys using corresponding
\link[dplyr:select_all]{scoped variant} of \link[dplyr:select]{select}. \code{.funs}
argument can be used to rename some keys (without touching actual keys)
before restoring.
}
\examples{
df <- mtcars \%>\% dplyr::as_tibble() \%>\% key_by(vs, am, disp)
# Just restore all keys
df \%>\% restore_keys_all()

# Restore all keys with renaming and without touching actual keys
df \%>\% restore_keys_all(.funs = toupper)

# Restore with renaming and removing
df \%>\%
  restore_keys_all(.funs = toupper, .remove = TRUE)

# Restore with renaming, removing and unkeying
df \%>\%
  restore_keys_all(.funs = toupper, .remove = TRUE, .unkey = TRUE)

# Restore with renaming keys satisfying the predicate
df \%>\%
  restore_keys_if(rlang::is_integerish, .funs = toupper)

# Restore with renaming specified keys
df \%>\%
  restore_keys_at(c("vs", "disp"), .funs = toupper)

}
