% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{delta.score}
\alias{delta.score}
\title{The change on objective function for greedy search implimentation}
\usage{
delta.score(adj.matrix, candidate, residual, i, j, type, M = Inf,
  T = ncol(adj.matrix), method, binary = FALSE, cmode, large = TRUE,
  geodist.precomp = NULL)
}
\arguments{
\item{adj.matrix}{The adjacency matrix of the network.}

\item{candidate}{An initial set of players selected.}

\item{residual}{The remaining players in the network without members in the initial set.}

\item{i}{The specific member in the candidate set to be replaced}

\item{j}{The specific member in the residual set to replace \code{i} in the candidate set}

\item{type}{Choose
\code{type="betweenness"} for betweenness centrality,
\code{type="closeness"} for closeness centrality,
\code{type="degree"} for degree centraslity,
\code{type="diffusion"} for diffusion centrality.
\code{type="evcent"} for eigenvector centrality,
\code{type="fragment"} for fragmentation centrality,
\code{type="mreach.degree"} for mreach.degree centrality, and
\code{type="mreach.closeness"} for mreach.closeness centrality.}

\item{M}{Positive number indicating the maximum distance between two nodes,
above witch the two nodes are considered disconnected. The default is
\code{Inf}.
The option is applicable to mreach.degree, mreach.closeness, fragmentation,
and diffusion centralities.}

\item{T}{Integer indicating the maximum number of iterations
of communication process. For diffusion centrality only.
In the first iteration, the adjacency matrix
is as the input. In the nth iteration, the adjacency matrix becomes
the input adjacency matrix to the power of n. By default, T is the network size.}

\item{method}{Indication of which grouping criterion should be used.
\code{method="min"} indicates the "minimum" criterion (edge values as distances).
\code{method="max"} indicates the "maximum" criterion (edge values as non-cummulative strengths).
\code{method="add"} indicates the "addition" criterion (edge values as cummulative strengths).
\code{method="union"} indicates the "union" criterion (edge values as probability).
By default, the minimun criterion is used for betweenness, closeness, fragmentation,
mreach.degree, and mreach.closeness centralities.
The maximun criterion is used for degree and eigenvector centralities.
The union criterion is used for diffusion centrality.}

\item{binary}{If \code{TRUE}, the adjacency matrix is binarized.
If \code{FALSE}, the edge values are considered. By default, \code{binary=FALSE}}

\item{cmode}{String indicating the type of centrality being evaluated.
The option is applicable to degree, mreach.degree, and mreach.closeness centralities.
The default is to report the total degree.
\code{cmode="outdegree"} and \code{cmode="indegree"} refer to indegree and outdegree
respectively. If \code{cmode="all"}, all the three types are reported.
The option can also applicable to closeness centrality.
See \code{\link[sna]{closeness}} Details section.
The default is to use the Gil-Schmidt power index.}

\item{large}{Logical scalar, whether the computation method for large network is
implemented. If \code{TRUE} (the default), the method implmented in \pkg{igraph} is
used; otherwise the method implemented in \pkg{sna} is used.}

\item{geodist.precomp}{Geodistance precomputed for the graph to be
analyzed (optional).}
}
\value{
The change in group centrality score
}
\description{
\code{delta.score} calculates the change in group centrality score.
}
\keyword{internal}

