% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ramp.R
\name{ramp}
\alias{ramp}
\title{Color Ramp}
\usage{
ramp(palette, ...)
}
\arguments{
\item{palette}{A \code{\link{character}} string giving the name of the palette to be
used (see \code{\link[=color]{color()}}).}

\item{...}{Further arguments to be passed to \code{\link[=color]{color()}}.}
}
\value{
A palette \code{\link{function}} with argument a vector of values that are mapped to
colors. The data midpoint can be specified with an additional \code{midpoint}
argument (see examples).
}
\description{
Provides a color scheme that map a \code{numeric} vector to colors.
}
\examples{
## Visualize a simple DEM model
## Distribution of elevation values
elevation <- hist(volcano)

## Where are breaks?
elevation$breaks

## Build palette function
ramp_BuRd <- ramp(palette = "BuRd")

(col <- ramp_BuRd(elevation$breaks))
image(volcano, col = col)
legend("topright", legend = attr(col, "breaks"), fill = col)

## Rescale to midpoint
(col <- ramp_BuRd(elevation$breaks, midpoint = 160))
image(volcano, col = col)
legend("topright", legend = attr(col, "breaks"), fill = col)
}
\seealso{
Other color palettes: 
\code{\link{colour}()},
\code{\link{info}()},
\code{\link{scale_picker}}
}
\author{
N. Frerebeau
}
\concept{color palettes}
\keyword{color}
