% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.R
\name{change}
\alias{change}
\title{Simulate Color-Blindness}
\usage{
change(x, mode)
}
\arguments{
\item{x}{A palette \code{\link{function}} that when called with a single
integer argument (the number of levels) returns a vector of colors
(see \code{\link[=color]{color()}}).}

\item{mode}{A \code{\link{character}} string giving the colorblind vision
to be used. It must be one of "\code{deuteranopia}", "\code{protanopia}",
"\code{tritanopia}" or "\code{achromatopsia}". Any unambiguous substring can be given.}
}
\value{
A palette \code{\link{function}} that returns a vector of anomalized
colors. All the attributes of the initial palette function are inherited,
with a supplementary attribute "\code{mode}" giving the corresponding
color-blind vision.
}
\description{
Simulate Color-Blindness
}
\examples{
if (requireNamespace("spacesXYZ", quietly = TRUE)) {
  ## Trichromat
  pal <- colour("bright")
  plot_scheme(pal(7))

  ## Deuteranopia
  deu <- change(pal, mode = "deuteranopia")
  plot_scheme(deu(7))

  ## Protanopia
  pro <- change(pal, mode = "protanopia")
  plot_scheme(pro(7))

  ## Tritanopia
  tri <- change(pal, mode = "tritanopia")
  plot_scheme(tri(7))

  ## Achromatopsia
  ach <- change(pal, mode = "achromatopsia")
  plot_scheme(ach(7))

  ## Plot simulated color blindness
  plot_scheme_colorblind(pal(7))
}
}
\references{
Brettel, H., Viénot, F. and Mollon, J. D. (1997). Computerized Simulation of
Color Appearance for Dichromats. \emph{Journal of the Optical Society of America
A}, 14(10), p. 2647-2655. \doi{10.1364/JOSAA.14.002647}.

Tol, P. (2018). \emph{Colour Schemes}. SRON. Technical Note No.
SRON/EPS/TN/09-002, issue 3.1.
URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}

Viénot, F., Brettel, H. and Mollon, J. D. (1999). Digital Video
Colourmaps for Checking the Legibility of Displays by Dichromats.
\emph{Color Research & Application}, 24(4), p. 243-52.
\doi{10.1002/(SICI)1520-6378(199908)24:4<243::AID-COL5>3.0.CO;2-3}.
}
\seealso{
Other diagnostic tools: 
\code{\link{compare}()},
\code{\link{plot.color_scheme}()},
\code{\link{plot_map}()},
\code{\link{plot_scheme}()},
\code{\link{plot_scheme_colourblind}()},
\code{\link{plot_tiles}()}
}
\author{
N. Frerebeau
}
\concept{diagnostic tools}
