% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_loop_progress.R
\name{print_loop_progress}
\alias{print_loop_progress}
\title{print loop progress}
\usage{
print_loop_progress(
  iteration_number = NULL,
  iteration_start = 1,
  iteration_end = NULL,
  text_before = "",
  percent = 1,
  output_method = "cat"
)
}
\arguments{
\item{iteration_number}{current number of iteration}

\item{iteration_start}{iteration number at which the loop begins
(default = 1)}

\item{iteration_end}{iteration number at which the loop ends.}

\item{text_before}{text to add before "Loop Progress..."
By default, it is set to be blank, i.e., \code{text_before = ""}}

\item{percent}{if \code{percent = 1}, progress level will be printed
at every 1 percent progress (default = 1)}

\item{output_method}{if \code{output_method = "cat"}, progress level
will be printed using the 'cat' function;
if \code{output_method = "return"}, progress level will be
returned as the output of the function (default = "cat")}
}
\description{
Print current progress inside a loop (e.g., for loop or lapply)
}
\examples{
for (i in seq_len(250)) {
  Sys.sleep(0.001)
  print_loop_progress(
    iteration_number = i,
    iteration_end = 250)
}
unlist(lapply(seq_len(7), function (i) {
  Sys.sleep(0.2)
  print_loop_progress(
    iteration_number = i,
    iteration_end = 7)
  return(i)
}))
}
