% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_datasets.R
\name{compare_datasets}
\alias{compare_datasets}
\title{compare data sets}
\usage{
compare_datasets(dataset_1 = NULL, dataset_2 = NULL, dataset_list = NULL)
}
\arguments{
\item{dataset_1}{a data object (a data frame or a data.table)}

\item{dataset_2}{another data object (a data frame or a data.table)}

\item{dataset_list}{list of data objects (data.frame or data.table)}
}
\value{
the output will be a data.table showing differences in data sets
}
\description{
Compares whether or not data sets are identical
}
\examples{
# catch differences in class attributes of the data sets
compare_datasets(
dataset_1 = data.frame(a = 1:2, b = 3:4),
dataset_2 = data.table::data.table(a = 1:2, b = 3:4))
# catch differences in number of columns
compare_datasets(
dataset_1 = data.frame(a = 1:2, b = 3:4, c = 5:6),
dataset_2 = data.frame(a = 1:2, b = 3:4))
# catch differences in number of rows
compare_datasets(
dataset_1 = data.frame(a = 1:2, b = 3:4),
dataset_2 = data.frame(a = 1:10, b = 11:20))
# catch differences in column names
compare_datasets(
dataset_1 = data.frame(A = 1:2, B = 3:4),
dataset_2 = data.frame(a = 1:2, b = 3:4))
# catch differences in values within corresponding columns
compare_datasets(
dataset_1 = data.frame(a = 1:2, b = c(3, 400)),
dataset_2 = data.frame(a = 1:2, b = 3:4))
compare_datasets(
dataset_1 = data.frame(a = 1:2, b = 3:4, c = 5:6),
dataset_2 = data.frame(a = 1:2, b = c(3, 4), c = c(5, 6)))
# check if data sets in a list are identical
compare_datasets(
dataset_list = list(
dt1 = data.frame(a = 1:2, b = 3:4, c = 5:6),
dt2 = data.frame(a = 1:2, b = 3:4),
dt3 = data.frame(a = 1:2, b = 3:4, c = 5:6)))
}
