% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogram.R
\name{histogram}
\alias{histogram}
\title{Histogram}
\usage{
histogram(
  vector = NULL,
  number_of_bins = 30,
  x_tick_marks = NULL,
  y_tick_marks = NULL,
  fill_color = "cyan4",
  border_color = "black",
  y_axis_title_vjust = 0.85,
  x_axis_title = NULL,
  y_axis_title = NULL,
  cap_axis_lines = FALSE,
  notify_na_count = NULL
)
}
\arguments{
\item{vector}{a numeric vector}

\item{number_of_bins}{number of bins for the histogram (default = 30)}

\item{x_tick_marks}{a vector of values at which to place tick marks
on the x axis (e.g., setting \code{x_tick_marks = seq(0, 10, 5)} will
put tick marks at 0, 5, and 10.)}

\item{y_tick_marks}{a vector of values at which to place tick marks
on the y axis (e.g., setting \code{y_tick_marks = seq(0, 10, 5)} will
put tick marks at 0, 5, and 10.)}

\item{fill_color}{color for inside of the bins (default = "cyan4")}

\item{border_color}{color for borders of the bins (default = "black")}

\item{y_axis_title_vjust}{position of the y axis title (default = 0.85).}

\item{x_axis_title}{title for x axis (default = "Value")}

\item{y_axis_title}{title for y axis (default = "Count")}

\item{cap_axis_lines}{logical. Should the axis lines be capped at the
outer tick marks? (default = FALSE)}

\item{notify_na_count}{if \code{TRUE}, notify how many observations
were removed due to missing values. By default, NA count will be printed
only if there are any NA values.}
}
\value{
the output will be a histogram, a ggplot object.
}
\description{
Create a histogram
}
\examples{
histogram(1:100)
histogram(c(1:100, NA))
histogram(vector = mtcars[["mpg"]])
histogram(vector = mtcars[["mpg"]], x_tick_marks = seq(10, 36, 2))
histogram(vector = mtcars[["mpg"]], x_tick_marks = seq(10, 36, 2),
y_tick_marks = seq(0, 8, 2), y_axis_title_vjust = 0.5,
y_axis_title = "Freq", x_axis_title = "Values of mpg")
}
