% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DispersalModel.R
\docType{class}
\name{DispersalModel-class}
\alias{DispersalModel-class}
\alias{DispersalModel}
\alias{show,DispersalModel-method}
\alias{initialize,DispersalModel-method}
\title{DispersalModel Class}
\usage{
\S4method{show}{DispersalModel}(object)

\S4method{initialize}{DispersalModel}(
  .Object,
  stages = NULL,
  dispersal_vector = NULL,
  fs = NULL,
  hs = NULL,
  sampling_stage = NULL,
  cycle = NULL,
  breeding_stage = NULL,
  visible_stage = NULL
)
}
\arguments{
\item{object}{an object of class \code{DispersalModel}}

\item{.Object}{object to be constructed into DispersalModel class}

\item{stages}{character.  Ordered vector of all dispersal stages across the breeding cycle of the modeled species}

\item{dispersal_vector}{numeric. Named vector of custom breeding cycle stages and their corresponding axial dispersal values}

\item{fs}{character.  breeding cycle stage at which first substantial FS-phased dispersal occurs}

\item{hs}{character. breeding cycle stage at which first substantial HS-phased dispersal occurs}

\item{sampling_stage}{character. stage in the breeding cycle at which samples are to be collected for kin identification.}

\item{cycle}{non-negative integer. Breeding cycle numbers of dispersed kin to be modeled.  Represents
the number of complete breeding cycles each simulated individual has undergone before the sampling point, where the time between
birth and first reproduction is coded as '0', that between first and second reproduction '1', etc. (default 0)}

\item{breeding_stage}{(character) - stage in the cycle at which breeding occurs. Must correspond to a previously described cycle
stage name. By default, equated with the .HS stage. This stage corresponds to the \strong{generation} of next-generation individuals;
the .FS & .HS stages correspond to their separation. Needed for situations where individuals are sampled before they separate from the parent.
Modify if the modeled .HS gamete dispersal event does not correspond to the initial breeding event.}

\item{visible_stage}{(character) - stage in the cycle at the \strong{beginning} of which individuals are visible to the study for
sampling rather than their parents (i.e. the beginning point of \code{cycle 0}). By default, equated with the \code{fs} stage. This parameter
determines how many dispersal stages individuals have gone through before they are sampled - if \code{.sampling_stage} occurs just
\strong{after} \code{.visible_stage}, the sampled individuals will have dispersed through only a small amount of the breeding cycle. if
\code{.sampling_stage} occurs just \strong{before} \code{.visible_stage}, the sampled individuals will have dispersed throughout most
of the breeding cycle before being sampled. If \code{.cycle} is set to \code{-1}, dispersal stages between breeding & visibility
can be accessed.}

\item{DispersalModel}{an object of class DispersalModel}
}
\value{
returns object of class \code{DispersalModel}

No return value. Called for side effects

returns an object of class \code{DispersalModel}
}
\description{
The class \code{DispersalModel} is an S4 Class supplying organism-specific information about dispersal stages (with axial
sigmas), FS & HS branch points, and the dispersal stage at which sampling occurs.It is used with the
\code{\link{simulate_kindist_custom}} function to enable the simulation of uniquely defined breeding & dispersal cycles.
}
\details{
The original simulation functions in this package (\code{simulate_kindist_simple()} & \code{simulate_kindist_composite}) were
designed for an organism with a specific (& relatively simple) breeding & dispersal cycle. 'simple' corresponded to a single
dispersal event across a lifespan, equivalency of all dispersal phases (FS, HS, PO) and no lifetime overlaps. 'composite'
corresponded to many insect dispersal situations, where breeding & oviposition are the key 'phase-defining' events (i.e.,
they lead to the initial gamete dispersal of half siblings & full siblings from each other), where field sampling typically
occurs via ovitraps

More general dispersal scenarios (e.g in mammals) require the ability to uniquely specify a variety of distinct breeding
ecologies & sampling schemes: the \code{DispersalModel} class paired with the \code{\link{simulate_kindist_custom}}
function achieves this by defining a breeding cycle with an arbitrary number of dispersal phases (the \code{dispersal_vector}
slot, accessed by the \code{\link{dispersal_vector}} method).

The breeding structure of a species may also impact at which stage
FS and HS phase branches occur. In \emph{Ae. aegypti}, males mate with multiple females in a (single) breeding season, and a female
typically carried the egg of only one male. In this context the FS (full-sibling) phase would be set to correspond to the female's
oviposition dispersal, while the HS (half-sibling) phase would be set to correspond to the male's breeding dispersal (as its gametes
will then be dispersed by multiple females across their gravid & ovipositional phases). However, in e.g. some species of the marsupial
\emph{Antechinus}, the FS branch point would be more appropriately associated with juveniles at the time that they leave the mother's
pouch. The \code{\link{fs}} and \code{\link{hs}} slots & accessor functions enable the assignment of these phase branches to any
defined life phase. Similarly, the \code{\link{sampling_stage}} slot & method allow the sampling point to be set to correspond to any
phase of the defined breeding cycle.

The next parameter stored in this object is the breeding cycle number \code{cycle}, accessed by the \code{\link{breeding_cycle}} method.
This parameter enables the treatment of species that undergo multiple breeding cycles in one lifetime. This is defined as a length two
vector describing the number of breeding cycles undergone by the final descendant of branch 1 and branch 2 of the dispersal pedigree before
their sampling (or after branching in the case of PO). (where branch one is the 'senior' and branch two the 'junior' member of the pedigree) (so uncle is branch one, nephew branch
two, grandmother branch one, granddaughter branch two, etc.). For each member of the resulting kin pair, the cycle number represents the
number of complete breeding cycles each individual has undergone before the sampling point, where the time between birth and first
reproduction is coded as '0', that between first and second reproduction '1', etc. This enables an application of the simulation
functions defined here to deal with populations with some amount of overlap between generations.

Note that this 'breeding cycle' approach is only applicable in situations where there is an approximate equivalence between the dispersal which
occurs in the first 'juvenile' breeding cycle and that which occurs between later breeding cycles. This parameter is implemented here, but it
will often be more productive to implement it instead as a parameter of the \code{\link{simulate_kindist_custom}} function (the cycle parameter
there if set overrides whatever was defined within this object)

The final parameter stored in this object is the breeding stage, \code{breeding_stage}. This describes the stage at which the
descendant individuals are generated (as opposed to \code{fs} & \code{hs}, which describe the point at which they are dispersed
from the parent)
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: print method

\item \code{initialize}: initialization method
}}

\section{Slots}{

\describe{
\item{\code{dispersal_vector}}{numeric. Named vector of custom breeding cycle stages and their corresponding axial dispersal values}

\item{\code{stages}}{character.  Ordered vector of all dispersal stages across the breeding cycle of the modeled species}

\item{\code{fs}}{character.  breeding cycle stage at which first substantial FS-phased dispersal occurs}

\item{\code{hs}}{character. breeding cycle stage at which first substantial HS-phased dispersal occurs}

\item{\code{sampling_stage}}{character. stage in the breeding cycle at which samples are to be collected for kin identification.}

\item{\code{cycle}}{non-negative integer. Breeding cycle numbers of dispersed kin to be modeled.  Represents
the number of complete breeding cycles each individual has undergone before the sampling point, where the time between
birth and first reproduction is coded as '0', that between first and second reproduction '1', etc. (default 0)}

\item{\code{breeding_stage}}{(character) - stage in the cycle at which breeding occurs. Must correspond to a previously described cycle
stage name. By default, equated with the .HS stage. This stage corresponds to the \strong{generation} of next-generation individuals;
the .FS & .HS stages correspond to their separation. Needed for situations where individuals are sampled before they separate from the parent.
Modify if the modeled .HS gamete dispersal event does not correspond to the initial breeding event.}

\item{\code{visible_stage}}{(character) - stage in the cycle at the \strong{beginning} of which individuals are visible to the study for
sampling rather than their parents (i.e. the beginning point of \code{cycle 0}). By default, equated with the \code{fs} stage. This parameter
determines how many dispersal stages individuals have gone through before they are sampled - if \code{.sampling_stage} occurs just
\strong{after} \code{.visible_stage}, the sampled individuals will have dispersed through only a small amount of the breeding cycle. if
\code{.sampling_stage} occurs just \strong{before} \code{.visible_stage}, the sampled individuals will have dispersed throughout most
of the breeding cycle before being sampled. If \code{.cycle} is set to \code{-1}, dispersal stages between breeding & visibility
can be accessed.}
}}

\seealso{
Other kdclasses: 
\code{\link{KinPairData-class}},
\code{\link{KinPairSimulation-class}}
}
\concept{kdclasses}
