% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sil.R
\name{sil}
\alias{sil}
\title{Silhouette index and plot}
\usage{
sil(distdata, idmedoid, idcluster, title = "")
}
\arguments{
\item{distdata}{A distance matrix (\emph{n x n}) or \emph{dist} object.}

\item{idmedoid}{A vector of id medoids (\emph{see} \strong{Details}).}

\item{idcluster}{A vector of cluster membership (\emph{see} \strong{Details}).}

\item{title}{A title of the plot.}
}
\value{
Function returns a list with following components:

\code{result} is a data frame of the silhouette indices for all objects

\code{plot} is the silhouette plots of each cluster.
}
\description{
This function creates silhouette indices and silhouette plots of
each cluster. The plot presents also the mean of the silhouette indices per
cluster.
}
\details{
The silhouette index of object \emph{i} is calculated by
\deqn{si(i)=\frac{b_i-a_i}{max(a_i, b_i)}}
where \eqn{a_i} is the average distance of object \emph{i} to all objects
within the cluster, and \eqn{b_i} is the average distance of object \emph{i}
to all objects within the nearest cluster.

The \code{idmedoid} argument corresponds to the \code{idcluster} argument.
If the length of \code{idmedoid} is 3, for example, the \code{idcluster} has
to have 3 unique memberships, or it returns \code{Error} otherwise. The
length of the \code{idcluster} has also to be equal to \emph{n}
(the number of objects).
}
\examples{
distiris <- as.matrix(dist(iris[,1:4]))
res <- fastkmed(distiris, 3)
silhouette <- sil(distiris, res$medoid, res$cluster)
silhouette$result[c(1:3,70:75,101:103),]
silhouette$plot

}
\references{
P. J. Rousseeuw. 1987 Silhouettes: a graphical aid to
the interpretation and validation of cluster analysis.
Journal of Computational and Applied Mathematics, vol. 20, pp. 53-65
}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
