% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read_rforge}
\alias{read_rforge}
\title{Read source code from R-Forge}
\usage{
read_rforge(path, project, extra = "")
}
\arguments{
\item{path}{Relative path to the source script on R-Forge.}

\item{project}{Name of the R-Forge project.}

\item{extra}{Extra parameters to be passed to the URL (e.g. \code{extra =
'&revision=48'} to check out the source of revision 48).}
}
\value{
A character vector of the source code.
}
\description{
This function reads source code from the SVN repositories on R-Forge.
}
\examples{\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(knitr)
# relies on r-forge.r-project.org being accessible
read_rforge("rgl/R/axes.R", project = "rgl")
read_rforge("rgl/R/axes.R", project = "rgl", extra = "&revision=519")
\dontshow{\}) # examplesIf}
}
\author{
Yihui Xie and Peter Ruckdeschel
}
