\docType{data}
\name{opts_template}
\alias{opts_template}
\title{Template for creating reusable chunk options}
\format{\preformatted{List of 4
 $ get    :function (name, default = FALSE, drop = TRUE)  
 $ set    :function (...)  
 $ merge  :function (values)  
 $ restore:function (target = value)  
}}
\usage{
opts_template
}
\description{
Creates a template binding a label to a set of chunk options. Every chunk
that references the template label will have the specificed set of options
applied to it.
}
\examples{
opts_template$set(myfigures = list(fig.height = 4, fig.width = 4))
# later you can reuse these chunk options by 'opts.label', e.g.

# <<foo, opts.label='myfigures'>>=

# the above is equivalent to <<foo, fig.height=4, fig.width=4>>=
}
\keyword{datasets}
