% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_optim_parallelf.R
\name{knn_optim_parallelf}
\alias{knn_optim_parallelf}
\title{Parallel k and d optimization reading from files}
\usage{
knn_optim_parallelf(y, k, d, v = 1, init = NULL, error_metric = "MAE",
  weight = "proximity", threads = NULL, file, cols)
}
\arguments{
\item{y}{A time series.}

\item{k}{Values of k;s to be analyzed.}

\item{d}{Values of d's to be analyzed.}

\item{v}{Variable to be predicted if given multivariate time series.}

\item{init}{Variable that determines the limit of the known past for the first instant predicted.}

\item{error_metric}{Type of metric to evaluate the prediction error.
Five metrics supported:
\describe{
  \item{ME}{Mean Error}
  \item{RMSE}{Root Mean Squared Error}
  \item{MAE}{Mean Absolute Error}
  \item{MPE}{Mean Percentage Error}
  \item{MAPE}{Mean Absolute Percentage Error}
}}

\item{weight}{Type of weight to be used at the time of calculating the predicted value with a weighted mean.
Three supported: proximity, same, linear.
\describe{
  \item{proximity}{the weight assigned to each neighbor is proportional to its distance}
  \item{same}{all neighbors are assigned with the same weight}
  \item{linear}{nearest neighbor is assigned with weight k, second closest neighbor with weight k-1, and so on until the
               least nearest neighbor which is assigned with a weight of 1.}
}}

\item{threads}{Number of threads to be used when parallelizing, default is number of cores detected - 1 or
1 if there is only one core.}

\item{file}{Path and id of the files where the distances matrixes are.}

\item{cols}{Number of columns per file.}
}
\value{
A matrix of errors, optimal k and d.
}
\description{
Optimizes the values of k and d for a given time series. First, values corresponding to instants from init + 1 to the last one
are predicted. The first value predicted, which corresponds to instant init + 1, is calculated using instants from 1 to
instant init; the second value predicted, which corresponds to instant init + 2, is predicted using instants from 1
to instant init + 1; and so on until the last value, which corresponds to instant n (length of the given time series),
is predicted using instants from 1 to instant n - 1. Finally, the error is evaluated between the predicted values and
the real values of the series.
This version of the optimization function uses a parallelized distances calculation function, and the computation of
the predicted values is done parallelizing by the number of d's and the number of instants to be predicted. Each thread
that calculates predicted values reads only the part of the corresponding distances matrix in which the information used
to predict is contained.
}
\examples{
knn_distances(AirPassengers, 1:3, file = "AirPassengers", cols = 2, threads = 2)
knn_optim_parallelf(AirPassengers, 1:5, 1:3, file = "AirPassengers", cols = 2, threads = 2)
knn_distances(LakeHuron, 1:6, file = "LakeHuron", cols = 10, threads = 2)
knn_optim_parallelf(LakeHuron, 1:10, 1:6, file = "LakeHuron", cols = 10, threads = 2)
}
