% Generated by roxygen2 (4.0.2): do not edit by hand
\name{knockoff.filter}
\alias{knockoff.filter}
\title{Knockoff filter}
\usage{
knockoff.filter(X, y, fdr = 0.2, statistic = NULL,
  threshold = c("knockoff", "knockoff+"), knockoffs = c("equicorrelated",
  "sdp"), normalize = TRUE)
}
\arguments{
\item{X}{matrix or data frame of predictors}

\item{y}{response vector}

\item{fdr}{target FDR (false discovery rate)}

\item{statistic}{the test statistic (by default, a lasso statistic). See the
Details section for more information.}

\item{threshold}{either 'knockoff' or 'knockoff+'.}

\item{knockoffs}{either equicorrelated knockoffs ('equicorrelated') or
knockoffs optimized using semidefinite programming ('sdp')}

\item{normalize}{whether to scale the data columns to have unit norm. Only
 disable this if your data is already normalized.}
}
\value{
An object of class "knockoff.result". This object is a list
 containing at least the following components:
 \item{knockoff}{matrix of knockoff variables}
 \item{statistic}{computed test statistic}
 \item{threshold}{computed selection threshold}
 \item{selected}{named vector of selected variables}
}
\description{
This function runs the knockoff procedure from start to finish, creating
the knockoffs, computing the test statistics, and selecting variables.
It is the main entry point for the knockoff package.
}
\details{
The default test statistic is \code{knockoff.stat.lasso_signed_max}.
Other useful test statistics include \code{knockoff.stat.fs} and
\code{knockoff.stat.fs_omp}. It is also possible to provide your own test
statistic (for an example, see the vignette).
}

