% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_equi.R
\name{create.solve_equi}
\alias{create.solve_equi}
\title{Optimization for equi-correlated fixed-X and Gaussian knockoffs}
\usage{
create.solve_equi(Sigma)
}
\arguments{
\item{Sigma}{positive-definite p-by-p covariance matrix.}
}
\value{
The solution \eqn{s} to the optimization problem defined above.
}
\description{
This function solves a very simple optimization problem needed to create fixed-X and 
Gaussian SDP knockoffs on the full the covariance matrix. This may be significantly
less powerful than \code{\link{create.solve_sdp}}.
}
\details{
Computes the closed-form solution to the semidefinite programming problem:
 \deqn{ \mathrm{maximize}  \; s \quad
       \mathrm{subject} \; \mathrm{to:}   \; 0 \leq s \leq 1, \;
       2\Sigma - sI \geq 0 }
used to generate equi-correlated knockoffs.

The closed form-solution to this problem is \eqn{s = 2\lambda_{\mathrm{min}}(\Sigma) \land 1}.
}
\seealso{
Other optimization: \code{\link{create.solve_asdp}},
  \code{\link{create.solve_sdp}}
}
