\docType{class}
\name{kRp.TTR,-class}
\alias{kRp.TTR,-class}
\alias{kRp.TTR-class}
\title{S4 Class kRp.TTR}
\description{
This class is used for objects that are returned by
\code{\link[koRpus:lex.div]{lex.div}} and its wrapper
functions (like \code{TTR}, \code{MSTTR}, \code{MTLD},
etc.).
}
\section{Slots}{

\describe{
\item{\code{param}}{Relevant parameters of the given analysis,
      as given to the function call, see \code{\link[koRpus:lex.div]{lex.div}} for details.}

\item{\code{tt}}{The analyzed text in tokenized form, with six elements ("tokens",
      "types", "lemmas", "num.tokens", "num.types", "num.lemmas").}

\item{\code{TTR}}{Value of the classic type-token ratio. NA if not calculated.}

\item{\code{MSTTR}}{Mean segmental type-token ratio, including the actual "MSTTR",
   TTR values of each segment ("TTR.seg"),
      and the number of dropped words due to segment size ("dropped"). NA if not calculated.}

\item{\code{MATTR}}{Moving-average type-token ratio, including the actual "MATTR",
   TTR values of each window ("TTR.win"),
      and standard deviation of TTRs ("sd"). NA if not calculated.}

\item{\code{C.ld}}{Herdan's C. NA if not calculated.}

\item{\code{R.ld}}{Guiraud's R. NA if not calculated.}

\item{\code{CTTR}}{Carroll's CTTR. NA if not calculated.}

\item{\code{U.ld}}{Uber Index. NA if not calculated.}

\item{\code{S.ld}}{Summer's S. NA if not calculated.}

\item{\code{K.ld}}{Yule's K. NA if not calculated.}

\item{\code{Maas}}{Maas' a. NA if not calculated.}

\item{\code{lgV0}}{Maas' \eqn{\lg{V_0}}. NA if not calculated.}

\item{\code{lgeV0}}{Maas' \eqn{\lg{}_{e}{V_0}}. NA if not calculated.}

\item{\code{Maas.grw}}{Maas' relative type growth \eqn{V'}. NA if not calculated.}

\item{\code{HDD}}{The actual HD-D value ("HDD"),
      a vector with the probabilies for each type ("type.probs"), a "summary"
   on these probabilities and their standard deviation "sd".}

\item{\code{MTLD}}{Measure of textual lexical diversity, including the actual "MTLD",
      two matrices with detailed
   information on forward and backward factorization ("all.forw" & "all.back"),
      a named vector holding both calculated
   factors and their mean value ("factors"),
      and a named list with information on the number or tokens in each factor, both
   forward and backward,
      as well as their mean and standard deviation ("lengths"). NA if not calculated.}

\item{\code{MTLDMA}}{Moving-average MTLD, including the actual "MTLDMA",
      its standard deviation, a list ("all") with detailed
   information on factorization and a named list with information on the number or tokens in each factor,
      as well as their mean
   and standard deviation ("lengths"). NA if not calculated.}

\item{\code{TTR.char}}{TTR values, starting with the first steplength of tokens,
      then adding the next one, progressing until
   the whole text is analyzed. The matrix has two colums,
      one for the respective step ("token") and one for the actual values
   ("value"). Can be used to plot TTR characteristic curves. NA if not calculated.}

\item{\code{MATTR.char}}{Equivalent to TTR.char,
      but calculated using MATTR algorithm. NA if not calculated.}

\item{\code{C.char}}{Equivalent to TTR.char,
      but calculated using Herdan's C algorithm. NA if not calculated.}

\item{\code{R.char}}{Equivalent to TTR.char,
      but calculated using Guiraud's R algorithm. NA if not calculated.}

\item{\code{CTTR.char}}{Equivalent to TTR.char,
      but calculated using Carroll's CTTR algorithm. NA if not calculated.}

\item{\code{U.char}}{Equivalent to TTR.char,
      but calculated using the Uber Index algorithm. NA if not calculated.}

\item{\code{S.char}}{Equivalent to TTR.char,
      but calculated using Summer's S algorithm. NA if not calculated.}

\item{\code{K.char}}{Equivalent to TTR.char,
      but calculated using Yule's K algorithm. NA if not calculated.}

\item{\code{Maas.char}}{Equivalent to TTR.char,
      but calculated using Maas' a algorithm. NA if not calculated.}

\item{\code{lgV0.char}}{Equivalent to TTR.char,
      but calculated using Maas' \eqn{\lg{V_0}} algorithm. NA if not calculated.}

\item{\code{lgeV0.char}}{Equivalent to TTR.char,
      but calculated using Maas' \eqn{\lg{}_{e}{V_0}} algorithm. NA if not calculated.}

\item{\code{HDD.char}}{Equivalent to TTR.char,
      but calculated using the HD-D algorithm. NA if not calculated.}

\item{\code{MTLD.char}}{Equivalent to TTR.char,
      but calculated using the MTLD algorithm. NA if not calculated.}

\item{\code{MTLDMA.char}}{Equivalent to TTR.char,
      but calculated using the moving-average MTLD algorithm. NA if not calculated.}
}}
\keyword{classes}

