% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions_lex.div.R
\name{CTTR}
\alias{CTTR}
\title{Lexical diversity: Carroll's corrected TTR (CTTR)}
\usage{
CTTR(txt, char = FALSE, ...)
}
\arguments{
\item{txt}{An object of either class \code{\link[koRpus:kRp.tagged-class]{kRp.tagged}} or \code{\link[koRpus:kRp.analysis-class]{kRp.analysis}},
      containing the tagged text to be analyzed.}

\item{char}{Logical,
      defining whether data for plotting characteristic curves should be calculated.}

\item{...}{Further valid options for the main function,
      see \code{\link[koRpus:lex.div]{lex.div}} for details.}
}
\value{
An object of class \code{\link[koRpus:kRp.TTR-class]{kRp.TTR}}.
}
\description{
This is just a convenient wrapper function for \code{\link[koRpus:lex.div]{lex.div}}.
}
\details{
Calculates Carroll's corrected TTR (CTTR). In contrast to
\code{\link[koRpus:lex.div]{lex.div}},
      which by default calculates all possible measures and
their progressing characteristics, this function will only calculate the CTTR value,
      and characteristics are
off by default.
}
\examples{
\dontrun{
CTTR(tagged.text)
}
}
\seealso{
\code{\link[koRpus:kRp.POS.tags]{kRp.POS.tags}},
 \code{\link[koRpus:kRp.tagged-class]{kRp.tagged}},
      \code{\link[koRpus:kRp.TTR-class]{kRp.TTR}}
}
\keyword{LD}
