% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lex.div.num.R
\name{lex.div.num}
\alias{lex.div.num}
\title{Calculate lexical diversity}
\usage{
lex.div.num(num.tokens, num.types, measure = c("TTR", "C", "R", "CTTR",
  "U", "S", "Maas"), log.base = 10, quiet = FALSE)
}
\arguments{
\item{num.tokens}{Numeric, the number of tokens.}

\item{num.types}{Numeric, the number of types.}

\item{measure}{A character vector defining the measures to calculate.}

\item{log.base}{A numeric value defining the base of the logarithm. See \code{\link[base:log]{log}} for details.}

\item{quiet}{Logical. If \code{FALSE}, short status messages will be shown.
\code{TRUE} will also suppress all potential warnings regarding the validation status of measures.}
}
\value{
An object of class \code{\link[koRpus:kRp.TTR-class]{kRp.TTR}}.
}
\description{
This function is a stripped down version of \code{\link[koRpus:lex.div]{lex.div}}. It does not analyze text,
but takes the numbers of tokens and types directly to calculate measures for which this information is sufficient:
\itemize{
   \item \code{"TTR"}{The classic \emph{Type-Token Ratio}}
   \item {\code{"C"}}{Herdan's \emph{C}}
   \item {\code{"R"}}{Guiraud's \emph{Root TTR}}
   \item {\code{"CTTR"}}{Carroll's \emph{Corrected TTR}}
   \item {\code{"U"}}{Dugast's \emph{Uber Index}}
   \item {\code{"S"}}{Summer's index}
   \item {\code{"Maas"}} {Maas' (\eqn{a^2})}
}
See \code{\link[koRpus:lex.div]{lex.div}} for further details on the formulae.
}
\examples{
lex.div.num(104, 43)
}
\references{
Maas, H.-D.,
      (1972). \"Uber den Zusammenhang zwischen Wortschatzumfang und L\"ange eines Textes. \emph{Zeitschrift f\"ur
     Literaturwissenschaft und Linguistik}, 2(8), 73--96.

   Tweedie. F.J. & Baayen,
      R.H. (1998). How Variable May a Constant Be? Measures of Lexical Richness in Perspective.
    \emph{Computers and the Humanities}, 32(5), 323--352.
}
\seealso{
\code{\link[koRpus:lex.div]{lex.div}}
}
\keyword{LD}
