% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_jumbleWords.R
\docType{methods}
\name{jumbleWords}
\alias{jumbleWords}
\alias{jumbleWords,kRp.text-method}
\alias{jumbleWords,character-method}
\title{Produce jumbled words}
\usage{
jumbleWords(words, ...)

\S4method{jumbleWords}{kRp.text}(words, min.length = 3, intact = c(start = 1, end = 1))

\S4method{jumbleWords}{character}(words, min.length = 3, intact = c(start = 1, end = 1))
}
\arguments{
\item{words}{Either a character vector or an object inheriting from class \code{\link[koRpus:kRp.text-class]{kRp.text}}.}

\item{...}{Additional options, currently unused.}

\item{min.length}{An integer value,
      defining the minimum word length. Words with less characters
will not be changed. Grapheme clusters are counted as one.}

\item{intact}{A named vector with the two integer values named \code{start} and \code{stop}.
These define how many characters of each relevant words will be left unchanged at its start
and its end, respectively.}
}
\value{
Depending on the class of \code{words}, either a character vector or an object of class
   \code{\link[koRpus:kRp.text-class]{kRp.text}} with the added feature \code{diff}.
}
\description{
This method either takes a character vector or objects inheriting class \code{kRp.text}
(i.e., text tokenized by \code{koRpus}),
      and jumbles the words. This usually means that the
first and last letter of each word is left intact,
      while all characters inbetween are being
randomized.
}
\examples{
\dontrun{
   jumbled.text <- jumbleWords(tagged.text)
}
}
