% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisualizationFunctions.R
\name{filt_plot_temporal}
\alias{filt_plot_temporal}
\title{Plot fixation filtered vs. raw gaze coordinates}
\usage{
filt_plot_temporal(
  data_in,
  plot.window = c(NA, NA),
  var1 = "x.raw",
  var2 = "x",
  verbose = TRUE
)
}
\arguments{
\item{data_in}{gaze matrix which must include columns for filtered and unfiltered data as specified in the var1 and var2 paramters}

\item{plot.window}{vector defining the time window to plot. If left empty, the 50-65% interval of the data are plotted. If the submitted values are
<0, they are assumed to be proportions, e.g., \code{plot.window = c(0.3,0.35)} plots the 30-35% interval of the data. Numbers >1 are assumed to refer to sample order
in the data}

\item{var1}{Name of the first variable to plot. Default "x.raw"}

\item{var2}{Name of the second variable to plot (overlayed on var1) Default: "x"}

\item{verbose}{If TRUE, print the resulting plot}
}
\value{
a ggplot with gaze coordinates plotted on the y axis and sample number on the x axis
}
\description{
This function plots and returns a ggplot2 figure showing two time series of gaze coordinates plotted against time.
The interval to plot can be defined as a proportion of the data frame or by sample numbers. Use this function to plot data before and after processing or filtering
to examine their effects. For example, unprocessed x or y coordinates can be plotted against x and y coordinates following pre-processing and/or a fixation filter.
Either the x or the y vector is plotted
}
\examples{
new.plot <- filt_plot_temporal(sample.data.filtered, plot.window = c(1000, 2000))
}
