% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tkonfound_fig.R
\name{tkonfound_fig}
\alias{tkonfound_fig}
\title{Draw Figures for Change in Effect Size in 2x2 Tables}
\usage{
tkonfound_fig(
  a,
  b,
  c,
  d,
  thr_p = 0.05,
  switch_trm = TRUE,
  test = "fisher",
  replace = "control"
)
}
\arguments{
\item{a}{Number of cases in the control group with unsuccessful outcomes.}

\item{b}{Number of cases in the control group with successful outcomes.}

\item{c}{Number of cases in the treatment group with unsuccessful outcomes.}

\item{d}{Number of cases in the treatment group with successful outcomes.}

\item{thr_p}{P-value threshold for statistical significance, default is 0.05.}

\item{switch_trm}{Whether to switch the two cells in the treatment or 
control row, default is TRUE (treatment row).}

\item{test}{Type of statistical test used, either "Fisher's Exact Test"
(default) or "Chi-square test".}

\item{replace}{Indicates whether to use the entire sample or just the control
group for calculating the base rate, default is "control".}
}
\value{
Returns two plots showing the effect of hypothetical case switches 
        on the effect size in a 2x2 table.
}
\description{
This function generates plots illustrating how the change in effect size 
is influenced by switching or replacing outcomes in a 2x2 table. It produces
two plots: one showing all possibilities (switching) and another zoomed in 
the area for positive RIR (Relative Impact Ratio).
}
