% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{burnin}
\alias{burnin}
\alias{burnin.krige}
\alias{burnin.matrix}
\title{Discard Burn-in Period of Kriging Model}
\usage{
burnin(object, n.burnin)

\method{burnin}{krige}(object, n.burnin = object$n.iter/2)

\method{burnin}{matrix}(object, n.burnin = nrow(object)/2)
}
\arguments{
\item{object}{An \code{krige} object from the \code{metropolis.krige} function.}

\item{n.burnin}{The number of burnin iterations. Defaults to half of the iterations.}
}
\description{
Discard burn-in period of a estimated model from \code{metropolis.krige}
}
\details{
The function discard the burn-in period from the results of \code{metropolis.krige}.
  It is generally used for discarding burn-in for \code{krige} object that keeps 
  all the iterations.
}
